<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Log;
use DateTime;
use Illuminate\Support\Carbon;

use Illuminate\Http\Request;

class AgencyController extends Controller
{
    public function handleAgencyPayment(request $request)
    {
        $orderID = $request->id;
        $amount = $request->id2;
        //dd($amount);

        $insertIntoDB = DB::table('tbl_transaction')->insertGetId([
            'orderID' => $orderID,
            'transaction_ref' => 'temp_val',
            // 'payment_method' => 'Remita',
            'payment_statusID' => 1,
            'amount' => $amount,
            'transaction_date' => now(),
        ]);

        // $updatequery = DB::table('tbl_order')
        //     ->where('order_id', $request->orderID)
        //     ->update(['order_statusID' => 5]);

        $today = date('Y-m-d H:i:s');
        $eff_date = date_create($today);
        $duration = date_add($eff_date, date_interval_create_from_date_string('365 days'));
        $end_date = date_format($duration, 'Y-m-d H:i:s');
        
        if ($insertIntoDB) {
            $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_transaction',
                    'tbl_transaction.orderID',
                    '=',
                    'tbl_order.order_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                ->WHERE('order_id', '=', $orderID)
                ->orderBy('transaction_date', 'desc')
                ->first();


            $policyno = 'VKA/' .$orderData->sku . '/'  .date('Y') .'/' . $orderData->upc . '/' .'10' . $orderData->order_id;
            //dd($policyno);
            
            if (session('planID')) {
 
                $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_transaction',
                    'tbl_transaction.orderID',
                    '=',
                    'tbl_order.order_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                 ->join(
                    'tbl_plans',
                    'tbl_plans.id',
                    '=',
                    'tbl_order.planID'
                )
                //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                ->WHERE('order_id', '=', $orderID)
                ->orderBy('transaction_date', 'desc')
                ->first();
                
                
                //dd($orderData);
                //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
                $dest_country = trim($orderData->destination_country);
                $orderData->subPolicy_price = $orderData->amount;
                $orderData->dest_country = $dest_country;
                
            }else{
                
                //if policy is travel insurance
                if ($orderData->policyID == 6 && strlen($orderData->planID) > 0) {
                    
                    $orderData = DB::table('tbl_order')
                    ->join(
                        'tbl_transaction',
                        'tbl_transaction.orderID',
                        '=',
                        'tbl_order.order_id'
                    )
                    ->join(
                        'tbl_subpolicy',
                        'tbl_subpolicy.upc',
                        '=',
                        'tbl_order.subPolicyID'
                    )
                    ->join(
                        'tbl_policy',
                        'tbl_policy.policy_id',
                        '=',
                        'tbl_subpolicy.policyID'
                    )
                     ->join(
                        'tbl_plans',
                        'tbl_plans.id',
                        '=',
                        'tbl_order.planID'
                    )
                    //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
                    ->WHERE('order_id', '=', $orderID)
                    ->orderBy('transaction_date', 'desc')
                    ->first();
                    // ->get()
                    // ->toArray();
                    
                    session(['planID' => $orderData->planID]);
                    //$dest_country = $this->getDestinationCountry($orderData[0]->destination_country);
                    $dest_country = trim($orderData->destination_country);
                    $orderData->subPolicy_price = $orderData->amount;
                    $orderData->dest_country = $dest_country;
                    
                }
            }
           // dd($orderData[0]->policyID);

            if ($orderData->policyID == 3) {

                 $uploadToNiid = DB::table('3rd_niid_web_service_register')
                     ->insert([
                        'policy_no' => $policyno,
                        'insured_name' => $orderData->firstName .' ' . $orderData->lastName,
                        'contact_address' => $orderData->address,
                        'gsm' => $orderData->phone,
                        'email' => $orderData->email,
                        'eff_from_date' => $today,
                        'eff_to_date' => $end_date,
                        'type_of_cover' => 'T',
                        'vehicle_category' => 'TBA',
                        'engine_no' => $orderData->car_reg_number,
                        'chasis_no' => $orderData->chasis_number,
                        'vehicle_color' => $orderData->colour,
                        'year_of_make' => 'year_made',
                        'vehicle_make' => $orderData->vehicle_make,
                        'registration_no' => $orderData->car_reg_number,
                        'vehicle_type' => $orderData->subPolicy_name,
                        'engine_capacity' => 'TBA',
                        'vehicle_model' => $orderData->vehicle_model,
                        'sum_assured' => $orderData->sum_insured,
                        'premium' => $orderData->subPolicy_price,
                        'cover_note_no' => 'TBA',
                        'certificate_no' => 'TBA',
                        'geographical_zone' => $orderData->state,
                        'message' => '',
                        'is_successful' => 0,
                        'date_attempted' => now(),
                     ]);

             }

        }
        
        if ($insertIntoDB || $uploadToNiid) {
            //naicom upload
            //dd($uploadToNiid);

            $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
            $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
            $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
            $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
            $companyType = 'G';
            $companyId = '74';
            $means_of_id = 'PASSPORT'; //$orderData['0']->form_of_id ?? $orderData['0']->form_of_id ?: 'PASSPORT';
            $means_of_id_number = $orderData->id_number ?? $orderData->id_number ?: '123456789';
            $insured =$orderData->firstName . ' ' . $orderData->lastName;
            $effective_date = date('m/d/Y H:i:s A', strtotime($today));
            $expiration_date = date('m/d/Y H:i:s A ', strtotime($end_date));
            $premium = $orderData->subPolicy_price;
            $product_name = $orderData->policy_name;
            $policy_number = $policyno;
            $sum_insured = $orderData->sum_insured;
            $registration_number = $orderData->car_reg_number;
            $address = $orderData->address;
            $phone =trim($orderData->phone) ?? trim($orderData->phone) ?:'+234(0)700 1000 500';
            $email =trim($orderData->email) ?? trim($orderData->email) ?:'info@veritaskapital.com';
            $last_name = $orderData->lastName ?? $$orderData->lastName[1] ?: 'n/a';
            
            $orderData->mapfre_certificate_url = "";
            $orderData->mapfre_policy_number = "";
            $orderData->mapfre_error_message = "";
            $orderData->mapfre_error = "";
            
            //if policy os travel insurance, make an an API call to mapfre for certificate
            if ($orderData->policyID == 6) {
                
                if (!session('planID')) {
                    session(['planID' => $orderData->planID]);
                }
                
                $today = date('Y-m-d H:i:s');
                $eff_date = date_create($today);
                $duration = date_add(
                    $eff_date,
                    date_interval_create_from_date_string('365 days')
                );
                $end_date = date_format($duration, 'Y-m-d H:i:s');

                $create_effective_date = date_create($orderData->departure_date);
                $effective_date = date_format($create_effective_date, "Y-m-d H:i:s");
                $create_expiration_date = date_create($orderData->return_date);
                $expiration_date = date_format($create_expiration_date, "Y-m-d H:i:s");
                $sum_insured = 'N/A';
				
				$mapfre_obj = new MapfreController;
                $generate_token = $mapfre_obj->generateToken();
                
                if($generate_token->getData()->status == 'success'){
                    $auth_token = $generate_token->getData()->data;
                    
                    $dt = new DateTime($orderData->departure_date);
                    $d_date = $dt->format('Y-m-d');
                    $dt1 = new DateTime($orderData->return_date);
                    $r_date = $dt1->format('Y-m-d');
                    
                    $travel_duration = $this->getDateDifference($d_date, $r_date);
                    $customer_age = $this->calculateAge($orderData->dob);
                    
                    //date difference does not include the start date in the days count, we add 1 to get the accurate number of days
                    $travel_duration = $travel_duration;
                    
                    $params = [
    					"auth_token" => $auth_token,
    					"travel_start_date" => $dt->format('d/m/Y'),
    					"travel_end_date" => $dt1->format('d/m/Y'),
    					"travel_duration" => $travel_duration,
    					"travel_country_id" => $orderData->destination_country,
    					"xml_product_code" => $orderData->xml_product_code,
    					"xml_product_id" => $orderData->xml_product_id,
    					"xml_suffijo" => $orderData->xml_suffijo,
    					"xml_cmbdestinosv" => $orderData->xml_cmbdestinosv,
    					"xml_cober_data" => $orderData->xml_cober_data,
    					"customer_first_name" => $orderData->firstName,
    					"customer_last_name" => $orderData->lastName,
    					"customer_dob" => $orderData->dob,
    					"customer_age" => $customer_age,
    					"customer_passport_number" => $orderData->id_number,
    					"customer_phone_number" => $orderData->phone,
    				];
    				
    				$generate_policy = $mapfre_obj->generatePolicy($params);
    				
    				if($generate_policy->getData()->status == 'success'){
    				    
    				    /*
    				        sample response
    				        &lt;idRegContrato&gt;620772&lt;/idRegContrato&gt;&lt;numContrato&gt;14WTVKNI&lt;/numContrato&gt;&lt;guid&gt;
    				        E4C0DA60-F02E-46B2-B3EE-9EA10BD66756&lt;/guid&gt;&lt;file&gt;
    				        https://www.mapfrewarranty.com/tmpfiles/943f3b4ed96b20a252f45111ae2cedac6f.pdf&lt;/file&gt;
    				    */
    				    
                        $policy_data = $generate_policy->getData()->data;
                        
                        //dd($policy_data);
                        
                        $mapfre_cert_url = $mapfre_obj->getStringpart($policy_data, "http", "&lt;/file&gt");
                        $mapfre_policy_number = $mapfre_obj->getStringpart($policy_data, "&lt;numContrato&gt;", "&lt;/numContrato&gt;");
                        $mapfre_policy_number = substr($mapfre_policy_number, 19);
                        
                        $orderData->mapfre_certificate_url = $mapfre_cert_url;
                        $orderData->mapfre_policy_number = $mapfre_policy_number;
                        $orderData->mapfre_error_message = "";
                        $orderData->mapfre_error = "success";
                        
                        // $SendCustomerEmail = (new MailController)->sendCustomerEmail($orderData, $insertIntoDB, $email);
                        // $SendRetailEmail = (new MailController)->sendRetailEmail($orderData, $policyno, $eff_date, $end_date, $transRef, $amount);
                        
                        //dd($mapfre_policy_number.' = '.$mapfre_cert_url);
    				}else{
    				    //Handle error if policy is not generated
    				    //dd($generate_policy);
    				    $error_message = $generate_policy->getData()->message;
    				    $orderData->mapfre_certificate_url = "";
                        $orderData->mapfre_policy_number = "";
                        $orderData->mapfre_error_message = $error_message;
                        $orderData->mapfre_error = "error";
                        
                        $SendErrorEmail = (new MailController)->sendTravelInsuranceErrorEmail($orderData, $error_message);
    				}
    				
                }else{
                    //Handle error if token is not generated
                    $error_message = $generate_token->getData()->message;
                    $orderData->mapfre_certificate_url = "";
                    $orderData->mapfre_policy_number = "";
                    $orderData->mapfre_error_message = $error_message;
                    $orderData->mapfre_error = "error";
                    
                    $SendErrorEmail = (new MailController)->sendTravelInsuranceErrorEmail($orderData, $error_message);
                    
                    //dd($generate_token);
                }
                
            }
            
            
            if($orderData->policyID == 6){
                $uploadToNaicom = true;
                $naicom_upload['PolicyUniqueID'] = "";   
            }else{
                switch ($orderData->policyID) {
                    case '3':
                        $post_data = [
                            "SID" => $sid_live,
                            "Token" => $token_live,
                            'Type' => 'Auto',
                            'DataGroup' => [
                                [
                                    'GroupName' => 'Basic Info',
                                    'GroupTag' => 0,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'TypeID',
                                            'Value' => '127',
                                        ],
                                        [
                                            'Name' => 'CoverageStartDate',
                                            'Value' => $effective_date,
                                        ],
                                        [
                                            'Name' => 'CoverageEndDate',
                                            'Value' => $expiration_date,
                                        ],
                                        [
                                            'Name' => 'PolicyInternalID',
                                            'Value' => $policy_number,
                                        ],
                                        [
                                            'Name' => 'PolicyDescription',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                        ],
                                    ],
                                ],
                                [
                                    'GroupName' => 'Detail Info',
                                    'GroupTag' => 1,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'CoverageType',
                                            'Value' => 'THIRD_PARTY',
                                        ],
                                        [
                                            'Name' => 'OwnerType',
                                            'Value' => 'PERSON',
                                        ],
                                        [
                                            'Name' => 'OwnerLicense',
                                            'Value' => $registration_number,
                                        ],
                                        [
                                            'Name' => 'PersonNameLast',
                                            'Value' => $last_name,
                                        ],
                                        [
                                            'Name' => 'PersonNameFirst',
                                            'Value' => $insured,
                                        ],
                                        [
                                            'Name' => 'OrgType',
                                            'Value' => 'PRIVATE',
                                        ],
                                        [
                                            'Name' => 'OrgName',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'OrgID',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'AddressLine',
                                            'Value' => $address,
                                        ],
                                        [
                                            'Name' => 'CityLGA',
                                            'Value' => 'Garki',
                                        ],
                                        [
                                            'Name' => 'State',
                                            'Value' => 'Kogi',
                                        ],
                                        [
                                            'Name' => 'PostCode',
                                            'Value' => '11755',
                                        ],
                                        [
                                            'Name' => 'Phone',
                                            'Value' => $phone,
                                        ],
                                        [
                                            'Name' => 'Email',
                                            'Value' => $email,
                                        ],
                                        [
                                            'Name' => 'InsuredValue',
                                            'Value' => '1000000',
                                        ],
                                        [
                                            'Name' => 'Premium',
                                            'Value' => $premium,
                                        ],
                                        [
                                            'Name' => 'CommissionFee',
                                            'Value' => '0',
                                        ],
                                        [
                                            'Name' => 'ExtraFee',
                                            'Value' => '0',
                                        ],
                                        [
                                            'Name' => 'PremiumNote',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Terms',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Preamble',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Endorsements',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Exclusions',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Exceptions',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Conditions',
                                            'Value' => 'n/a',
                                        ],
                                    ],
                                ],
                                [
                                    'GroupName' => 'Insured Info',
                                    'GroupTag' => 2,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'InsuredNo',
                                            'Value' => '1',
                                        ],
                                        [
                                            'Name' => 'VehicleID',
                                            'Value' => $registration_number,
                                        ],
                                        [
                                            'Name' => 'PlateNo',
                                            'Value' => $registration_number,
                                        ],
                                        [
                                            'Name' => 'RegNo',
                                            'Value' => $registration_number,
                                        ],
                                        [
                                            'Name' => 'RegDate',
                                            'Value' => 'June 07, 2020', //strtotime('m d, Y')
                                        ],
                                        [
                                            'Name' => 'RegExpDate',
                                            'Value' => 'June 07, 2024',
                                        ],
                                        [
                                            'Name' => 'RegMileage',
                                            'Value' => '100000',
                                        ],
                                        [
                                            'Name' => 'AutoType',
                                            'Value' => 'CAR',
                                        ],
                                        [
                                            'Name' => 'AutoMake',
                                            'Value' =>
                                                $orderData->vehicle_make,
                                        ],
                                        [
                                            'Name' => 'AutoModel',
                                            'Value' =>
                                                $orderData->vehicle_model,
                                        ],
                                        [
                                            'Name' => 'AutoColor',
                                            'Value' => 'Custom',
                                        ],
                                        [
                                            'Name' => 'AutoYear',
                                            'Value' => '2020',
                                        ],
                                        [
                                            'Name' => 'EngineCap',
                                            'Value' => '2.5',
                                        ],
                                        [
                                            'Name' => 'SeatCap',
                                            'Value' => '5',
                                        ],
                                        [
                                            'Name' => 'AutoNote',
                                            'Value' => 'n/a',
                                        ],
                                    ],
                                ],
                            ],
                        ];
                        break;
                    case '4':
                        $product_type_id = '30';
                        $post_data = [
                            "SID" => $sid_live,
                            "Token" => $token_live,
                            'Type' => 'Fire',
                            'DataGroup' => [
                                [
                                    'GroupName' => 'Basic Info',
                                    'GroupTag' => 0,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'TypeID',
                                            'Value' => $product_type_id,
                                        ],
                                        [
                                            'Name' => 'CoverageStartDate',
                                            'Value' => $effective_date,
                                        ],
                                        [
                                            'Name' => 'CoverageEndDate',
                                            'Value' => $expiration_date,
                                        ],
                                        [
                                            'Name' => 'PolicyInternalID',
                                            'Value' => $policy_number,
                                        ],
                                        [
                                            'Name' => 'PolicyDescription',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                        ],
                                    ],
                                ],
                                [
                                    'GroupName' => 'Detail Info',
                                    'GroupTag' => 1,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'CustomerName',
                                            'Value' => $insured,
                                        ],
                                        [
                                            'Name' => 'CustomerBuildingDoorNo',
                                            'Value' => '3',
                                        ],
                                        [
                                            'Name' => 'CustomerBuildingName',
                                            'Value' => 'Personal Building',
                                        ],
                                        [
                                            'Name' => 'CustomerBuildingAddressLine',
                                            'Value' => $address,
                                        ],
                                        [
                                            'Name' =>
                                                'CustomerBuildingAddressCityLGA',
                                            'Value' => 'Abuja',
                                        ],
                                        [
                                            'Name' =>
                                                'CustomerBuildingAddressState',
                                            'Value' => 'Kaduna',
                                        ],
                                        [
                                            'Name' =>
                                                'CustomerBuildingAddressPostCode',
                                            'Value' => '900211',
                                        ],
                                        [
                                            'Name' => 'CustomerPhone',
                                            'Value' => $phone,
                                        ],
                                        [
                                            'Name' => 'CustomerEmail',
                                            'Value' => $email,
                                        ],
                                        [
                                            'Name' => 'PropertyBusiness',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'PropertyConstruction',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'PropertyConstructionValue',
                                            'Value' => $sum_insured,
                                        ],
                                        [
                                            'Name' => 'PropertyContent',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'PropertyContentValue',
                                            'Value' => $sum_insured,
                                        ],
                                        [
                                            'Name' => 'FireCoverageDetail',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'FireProtectionDetail',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'FireHistory',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'BurglaryCoverageDetail',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'BurglaryAntiTheftDetail',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'BurglaryHistory',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'HouseBuildingType',
                                            'Value' => 'PRIVATE_DEVELLING',
                                        ],
                                        [
                                            'Name' => 'HouseCoverageDetail',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'HouseSecurityDetail',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'HouseHistory',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'InsuredValue',
                                            'Value' => $sum_insured,
                                        ],
                                        [
                                            'Name' => 'Premium',
                                            'Value' => $premium,
                                        ],
                                        [
                                            'Name' => 'CommissionFee',
                                            'Value' => '0',
                                        ],
                                        [
                                            'Name' => 'ExtraFee',
                                            'Value' => '0',
                                        ],
                                        [
                                            'Name' => 'PremiumNote',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Terms',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Preamble',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Endorsements',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Exclusions',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Exceptions',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Conditions',
                                            'Value' => 'n/a',
                                        ],
                                    ],
                                ],
                            ],
                        ];
                        //End of Fire Insurance
                        break;
    
                    case '1':
                        $product_type_id = '53';
    
                        $post_data = [
                            "SID" => $sid_live,
                            "Token" => $token_live,
                            'Type' => 'misc',
                            'DataGroup' => [
                                [
                                    'GroupName' => 'Basic Info',
                                    'GroupTag' => 0,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'TypeID',
                                            'Value' => 53,
                                        ],
                                        [
                                            'Name' => 'CoverageStartDate',
                                            'Value' => $effective_date,
                                        ],
                                        [
                                            'Name' => 'CoverageEndDate',
                                            'Value' => $expiration_date,
                                        ],
                                        [
                                            'Name' => 'PolicyInternalID',
                                            'Value' => $policy_number,
                                        ],
                                        [
                                            'Name' => 'PolicyDescription',
                                            'Value' => $product_name,
                                        ],
                                        [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                        ],
                                    ],
                                ],
                                [
                                    'GroupName' => 'Detail Info',
                                    'GroupTag' => 1,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'HolderType',
                                            'Value' => 'INDIVIDUAL',
                                        ],
                                        [
                                            'Name' => 'PersonNameLast',
                                            'Value' => $insured,
                                        ],
                                        [
                                            'Name' => 'PersonNameFirst',
                                            'Value' => $last_name,
                                        ],
                                        [
                                            'Name' => 'PersonIDDoc',
                                            'Value' => $means_of_id,
                                        ],
                                        [
                                            'Name' => 'PersonIDNo',
                                            'Value' => $means_of_id_number,
                                        ],
                                        [
                                            'Name' => 'AddressLine',
                                            'Value' => $address,
                                        ],
                                        [
                                            'Name' => 'CityLGA',
                                            'Value' => 'Abuja',
                                        ],
                                        [
                                            'Name' => 'State',
                                            'Value' => 'Abia',
                                        ],
                                        [
                                            'Name' => 'PostCode',
                                            'Value' => '90211',
                                        ],
                                        [
                                            'Name' => 'Phone',
                                            'Value' => $phone,
                                        ],
                                        [
                                            'Name' => 'Email',
                                            'Value' => $email,
                                        ],
                                        [
                                            'Name' => 'InsuranceDescription',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'InsuredValue',
                                            'Value' => $sum_insured,
                                        ],
                                        [
                                            'Name' => 'Premium',
                                            'Value' => $premium,
                                        ],
                                        [
                                            'Name' => 'CommissionFee',
                                            'Value' => '0',
                                        ],
                                        [
                                            'Name' => 'ExtraFee',
                                            'Value' => '0',
                                        ],
                                        [
                                            'Name' => 'PremiumNote',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Terms',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Preamble',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Endorsements',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Exclusions',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Exceptions',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Conditions',
                                            'Value' => 'n/a',
                                        ],
                                    ],
                                ],
                            ],
                        ];
                        //End of Personal Insurance
                        break;
    
                    case '2':
                        $product_type_id = '53';
    
                        $post_data = [
                            "SID" => $sid_live,
                            "Token" => $token_live,
                            'Type' => 'misc',
                            'DataGroup' => [
                                [
                                    'GroupName' => 'Basic Info',
                                    'GroupTag' => 0,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'TypeID',
                                            'Value' => '54',
                                        ],
                                        [
                                            'Name' => 'CoverageStartDate',
                                            'Value' => $effective_date,
                                        ],
                                        [
                                            'Name' => 'CoverageEndDate',
                                            'Value' => $expiration_date,
                                        ],
                                        [
                                            'Name' => 'PolicyInternalID',
                                            'Value' => $policy_number,
                                        ],
                                        [
                                            'Name' => 'PolicyDescription',
                                            'Value' => $product_name,
                                        ],
                                        [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                        ],
                                    ],
                                ],
                                [
                                    'GroupName' => 'Detail Info',
                                    'GroupTag' => 1,
                                    'GroupCount' => 0,
                                    'AttArray' => [
                                        [
                                            'Name' => 'HolderType',
                                            'Value' => 'INDIVIDUAL',
                                        ],
                                        [
                                            'Name' => 'PersonNameLast',
                                            'Value' => $insured,
                                        ],
                                        [
                                            'Name' => 'PersonNameFirst',
                                            'Value' => $last_name,
                                        ],
                                        [
                                            'Name' => 'PersonIDDoc',
                                            'Value' => $means_of_id,
                                        ],
                                        [
                                            'Name' => 'PersonIDNo',
                                            'Value' => $means_of_id_number,
                                        ],
                                        [
                                            'Name' => 'AddressLine',
                                            'Value' => $address,
                                        ],
                                        [
                                            'Name' => 'CityLGA',
                                            'Value' => 'Abuja',
                                        ],
                                        [
                                            'Name' => 'State',
                                            'Value' => 'Abia',
                                        ],
                                        [
                                            'Name' => 'PostCode',
                                            'Value' => '90211',
                                        ],
                                        [
                                            'Name' => 'Phone',
                                            'Value' => $phone,
                                        ],
                                        [
                                            'Name' => 'Email',
                                            'Value' => $email,
                                        ],
                                        [
                                            'Name' => 'InsuranceDescription',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'InsuredValue',
                                            'Value' => $sum_insured,
                                        ],
                                        [
                                            'Name' => 'Premium',
                                            'Value' => $premium,
                                        ],
                                        [
                                            'Name' => 'CommissionFee',
                                            'Value' => '0',
                                        ],
                                        [
                                            'Name' => 'ExtraFee',
                                            'Value' => '0',
                                        ],
                                        [
                                            'Name' => 'PremiumNote',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Terms',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Preamble',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Endorsements',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Exclusions',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Exceptions',
                                            'Value' => 'n/a',
                                        ],
                                        [
                                            'Name' => 'Conditions',
                                            'Value' => 'n/a',
                                        ],
                                    ],
                                ],
                            ],
                        ];
                        //End of House Holder Insurance
                        break;
                    case '7':
                        $post_data = [
                        // 'SID' => $sid_live,
                        // 'Token' => $sid_live,
                        'SID' => $sid_test,
                        'Token' => $token_test,
                        'Type' => 'Marine',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'Insurer',
                                        'Value' => 'Veritas Kapital Assurance PLC',
                                    ],[
                                        'Name' => 'TypeID',
                                        'Value' => '41',
                                    ],[
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],[
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],[
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],[
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],[
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],[
                                        'Name' => 'DetailType',
                                        'Value' => 'Marine',
                                    ],[
                                        'Name' => 'InsuredType',
                                        'Value' => 'Marine',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'OwnerName',
                                        'Value' => $insured,
                                    ],[
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Kogi',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],[
                                        'Name' => 'CoverageType',
                                        'Value' => 'General',
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $orderData->percent_sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VessleName',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleRegNo',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleType',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VessleInsuredValue',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'VessleBuildYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'VessleMakeModel',
                                        'Value' => 'VESSEL',
                                    ],
                                    [
                                        'Name' => 'VesslePurchaseYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'VesslePurchaseValue',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'VessleUsage',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'VessleCapacityPassenger',
                                        'Value' => '12',
                                    ],
                                    [
                                        'Name' => 'VessleNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                }
    
    
                $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
                $url_test = 'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';
    
    
                $curl = curl_init();
    
                curl_setopt_array($curl, [
                    CURLOPT_URL => $url_test,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => json_encode($post_data),
                    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
                ]);
    
                $response = curl_exec($curl);
    
                curl_close($curl);
    
                $naicom_upload = json_decode($response, true);
                //dd($curl);
                //dd($naicom_upload);
                //SAVE NAICOM RETURN RECORD TO DB
                $uploadToNaicom = DB::table('naicom_upload')->insert([
                    'policy_number' => $policyno,
                    'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                    'naicom_policy_id' => $naicom_upload['PolicyID'],
                    'insured_name' => $insured,
                    'contact_address' => $address,
                    'phone' => $phone,
                    'email' => $email,
                    'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
                    'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                    'sum_assured' => $sum_insured,
                    'premium' => $premium,
                    'product_name' => $product_name,
                    'date_attempted' => date('Y-m-d H:i:s'),
                    'message' => !empty($naicom_upload['ErrMsgs']['0'])
                        ? $naicom_upload['ErrMsgs']['0']
                        : 'Successful',
                    'is_successful' => $naicom_upload['IsSucceed'],
                    'create_by' => $email,
                ]);
                //$naicom_data =  new stdClass();
                //dd($uploadToNaicom);
            }
            
            // add NAICOM uid and policy_no to transactions table
            if ($uploadToNaicom) {
                $updatetransactions = DB::table('tbl_transaction')
                    ->where('transaction_id', $orderData->transaction_id)
                    ->update([
                        'policy_number' => $policyno,
                        'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                        //'transaction_ref' => $orderData->remitaID,
                        'eff_from_date' => date('Y-m-d',strtotime($today)),
                        'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                        'mapfre_certificate_url' => $orderData->mapfre_certificate_url,
                        'mapfre_policy_number' => $orderData->mapfre_policy_number,
                        'mapfre_response' => $orderData->mapfre_error_message,
                    ]);

                    $uploadToReports = DB::table('retail_report')->insert([
                        'firstname' => $orderData->firstName,
                        'lastname' => $last_name,
                        'email' => $email,
                        'address' => $address,
                        'telephone' => $phone,
                        'order_id' => $orderID,
                        'order_status' => $orderData->order_statusID,
                        'product_name' => $product_name,
                        'product_model' => $product_name,
                        'price' => $premium,
                        'policy_number' => $policyno,
                        'sku' => $orderData->sku,
                        'upc' => $orderData->upc,
                        'form_of_id' => $orderData->form_of_id,
                        'id_number' => $orderData->id_number,
                        'vehicle_make' => $orderData->vehicle_make,
                        'vehicle_model' => $orderData->vehicle_model,
                        'reg_no' => $sum_insured,
                        'chassis_no' => $orderData->chasis_number,
                        'color' => $orderData->colour,
                        'date_added' => date('Y-m-d H:i:s'),
                        'end_date' => $end_date,
                    ]);
                # code...
                if ($updatetransactions && $uploadToReports) {
                    //$SendCustomerEmail = (new MailController)->sendCustomerEmail($orderData, $insertIntoDB, $email);
                    //$SendRetailEmail = (new MailController)->sendRetailEmail($orderData, $policyno, $eff_date, $end_date, $transRef, $amount);
                    session()->pull('orderID');
                    if (session('planID')) {
                        session()->pull('planID');
                    }   

                    //session()->put('transID', $orderData['0']->transaction_id);

                    //return view('body.purchaseSuccess', compact('orderData'));
                    return 'success';
                }
            }
        }
    }
    
    public function getDateDifference($fromDate, $toDate)
    {
        $to = Carbon::createFromFormat('Y-m-d', $toDate);

        $from = Carbon::createFromFormat('Y-m-d', $fromDate);

        $diff_in_days = $to->diffInDays($from);
        
        //date difference does not include the start date in the days count, we add 1 to get the accurate number of days
        return ($diff_in_days + 1);
    }
    
    public function calculateAge($date) 
    {
        $date = new \Carbon\Carbon($date);
        return (int) $date->diffInYears();
    }
    
    public function agencyUnremitted()
    {
        $getTransaction = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
            //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
            ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
            ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
            ->WHERE('tbl_customer.teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
            ->orderBy('transaction_date', 'DESC')
        ->get();

        $total = 0;
        //$rrr = [];

        for ($i = 0; $i < count($getTransaction); $i++) {

            $ifExist = DB::table('tbl_team')
            //->WHERE('policyID', '=', $getTransaction[$i]->policy_id)
            ->where('team_id', '=',  session('teamId'))
            ->get();
            
            //dd($ifExist);

            if (!$ifExist || empty($ifExist) || count($ifExist) < 1) {
                $sum = 0;
            }else{
                $sum = (((100 - $ifExist['0']->comission_rate)/100) * $getTransaction[$i]->amount);
                //$rrr[$i] = [$ifExist[0]->commission_percentage, $getTransaction[$i]->amount];
            }
 
            $total += $sum;
        }

        //dd($rrr);
        
        $getWallet = DB::table('tbl_wallet')
            ->WHERE('customerID', '=', session('user_id'))
        ->first();



        $getSum = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
            //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
            ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
            ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
            ->WHERE('tbl_customer.teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
            ->sum('amount');

        //dd($getTransaction);
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
        ->get();

        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        return view('body.customer.teamUnremitted', compact('getTransaction', 'getWallet', 'customerData', 'countUnremitted', 'getSum', 'total'));

    }
    
    
    //Working Version before update to fetch comission rate from tbl_team instead of team_has_policy. This is to accommodate Marine insurance
    // public function agencyUnremitted()
    // {
    //     $getTransaction = DB::table('tbl_order')
    //         ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
    //         ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
    //         //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
    //         ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
    //         ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
    //         ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
    //         ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
    //         ->WHERE('tbl_customer.teamID', '=', session('teamId'))
    //         ->WHERE('payment_statusID', '<>', 5)
    //         ->orderBy('transaction_date', 'DESC')
    //     ->get();

    //     $total = 0;
    //     //$rrr = [];

    //     for ($i = 0; $i < count($getTransaction); $i++) {

    //         $ifExist = DB::table('tbl_team_has_policy')
    //         ->WHERE('policyID', '=', $getTransaction[$i]->policy_id)
    //         ->where('teamID', '=',  $getTransaction[$i]->teamID)
    //         ->get();
            
    //         //dd($ifExist);

    //         if (!$ifExist || empty($ifExist) || count($ifExist) < 1) {
    //             $sum = 0;
    //         }else{
    //             $sum = (((100 - $ifExist[0]->commission_percentage)/100) * $getTransaction[$i]->amount);
    //             //$rrr[$i] = [$ifExist[0]->commission_percentage, $getTransaction[$i]->amount];
    //         }
 
    //         $total += $sum;
    //     }

    //     //dd($rrr);



    //     $getSum = DB::table('tbl_order')
    //         ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
    //         ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
    //         //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
    //         ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
    //         ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
    //         ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
    //         ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
    //         ->WHERE('tbl_customer.teamID', '=', session('teamId'))
    //         ->WHERE('payment_statusID', '<>', 5)
    //         ->sum('amount');

    //     //dd($getTransaction);
    //     $customerData = DB::table('tbl_customer')
    //         ->WHERE('customer_id', '=', session('user_id'))
    //     ->get();

    //     $countUnremitted = DB::table('tbl_order')
    //         ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
    //         ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
    //         ->WHERE('teamID', '=', session('teamId'))
    //         ->WHERE('payment_statusID', '<>', 5)
    //     ->count();

    //     return view('body.customer.teamUnremitted', compact('getTransaction', 'customerData', 'countUnremitted', 'getSum', 'total'));

    // }
    
    public function adminAgencyUnremitted()
    {
        $getTransaction = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
            //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
            ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
            ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
            ->WHERE('tbl_transaction.payment_statusID', '=', 1)
            ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
            ->orderBy('transaction_date', 'DESC')
            ->get();

        $total = 0;
        //$rrr = [];

        for ($i = 0; $i < count($getTransaction); $i++) {
            $ifExist = DB::table('tbl_team_has_policy_marine')
                ->where('policyID', '=', $getTransaction[$i]->policy_id)
                ->where('teamID', '=', $getTransaction[$i]->teamID)
                ->get();
        
            if (count($ifExist) > 0) {
                // The $ifExist array has elements
                $sum = (((100 - $ifExist[0]->premium_percentage) / 100) * $getTransaction[$i]->amount);
                //$rrr[$i] = [$ifExist[0]->commission_percentage, $getTransaction[$i]->amount];
            } else {
                // The $ifExist array is empty
                $sum = 0;
            }
        
            $total += $sum;
        }


        //dd($rrr);

        $getSum = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
            //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
            ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
            ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
            ->WHERE('tbl_transaction.payment_statusID', '=', 1)
            ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
            ->sum('amount');

        //dd($getTransaction);
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
            ->get();

        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('tbl_transaction.payment_statusID', '=', 1)
            ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
            ->count();

        return view('body.customer.teamUnremittedAdmin', compact('getTransaction', 'customerData', 'countUnremitted', 'getSum', 'total'));

    }

    public function verifyPayment($reference, $vendor_id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/".$reference, 
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                //"Authorization: Bearer sk_test_ed0517bf606e293e42e1e61bfb5b32455e1950e1",
                "Authorization: Bearer sk_live_e4d90ae11137a804dcdeb86cb82c47e5b327c692",
                "Cache-Control: no-cache",
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            return json_encode(array('status' => 'error', 'message' => 'Error Encountered', 'dev_message' => 'cURL Error #:' . $err.''));
        } else {
            $json_response = json_decode($response);
            //dd($json_response);
            if($json_response->status && $json_response->data->status == 'success'){
                
                $amount = $json_response->data->amount/100;
                
                if(session('userLevel') == "4"){
                    $metadata = $json_response->data->metadata;

                    // Access individual custom fields using their keys
                    $payIds = $metadata->payIds;
                    $payIdsArray = explode(',', $payIds);
                    
                    //dd($payIdsArray);
                
                    $update_response = $this->updateAdminAgentPayments($vendor_id, $payIdsArray, $json_response->data->reference, $amount);
                }else{
                    $update_response = $this->updateAgentPayments($vendor_id, $json_response->data->reference, $amount);
                }
                //$update_response = json_decode($update_response);

                return $update_response;
            }else{
                return $json_response->message;
            }
        }
    }

    public function updateAgentPayments($vendor_id, $transaction_id, $amount_paid)
    {
        $updateAgencyTransaction = DB::table('tbl_agency_transaction')->insert([
            'teamID' => $vendor_id,
            'trans_reference' => $transaction_id,
            'amount' => $amount_paid,
            'trans_date' => now(),
        ]);

        $getTransaction = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')

            ->WHERE('teamID', '=', $vendor_id)
            ->WHERE('payment_statusID', '<>', 5)
        ->get();


        foreach ($getTransaction as $trans) {
           //$updateAgencyTransaction =  DB::table('tbl_agency_transaction')->where('teamID', $vendor_id)->update(['order_statusID' => 5 ]);

           $updateTransaction = DB::table('tbl_transaction')->where('orderID', $trans->orderID)->update([
            'payment_statusID' => 5,
            'transaction_ref' => $transaction_id,
            'transaction_date' => now()
        ]);
        //dd($updateTransaction);
        }

        if ($updateTransaction && $updateAgencyTransaction) {
            return json_encode(array('status' => 'success', 'message' => 'Payment Successful'));
        }

    }
    
    public function updateAdminAgentPayments($vendor_id, $payIdsArray, $transaction_ref, $amount)
    {
        $updateAgencyTransaction = DB::table('tbl_agency_transaction')->insert([
            'teamID' => $vendor_id,
            'trans_reference' => $transaction_ref,
            'amount' => $amount,
            'trans_date' => now(),
        ]);

        foreach ($payIdsArray as $transId) {
           //$updateAgencyTransaction =  DB::table('tbl_agency_transaction')->where('teamID', $vendor_id)->update(['order_statusID' => 5 ]);
           
           $getTransaction = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('tbl_transaction.transaction_id', '=', $transId)
            ->WHERE('payment_statusID', '<>', 5)
            ->get();
            
            if ($getTransaction->isNotEmpty()) {
                // Use count if needed
                $transactionCount = $getTransaction->count();
                $firstTransaction = $getTransaction->first();

                $updateTransaction = DB::table('tbl_transaction')->where('orderID', $firstTransaction->orderID)->update([
                    'payment_statusID' => 5,
                    'transaction_ref' => $transaction_ref,
                    'transaction_date' => now()
                ]);
            }
        
        //dd($updateTransaction);
        }

        if ($updateTransaction && $updateAgencyTransaction) {
            return json_encode(array('status' => 'success', 'message' => 'Payment Successful'));
        }

    }

    public function agencyTransaction()
    {
        $TransactionData = DB::table('tbl_agency_transaction')
            // ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            // ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            //->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
            //->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
            //->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
            ->WHERE('teamID', '=', session('teamId'))
           // ->WHERE('payment_statusID', '<>', 5)
            ->orderBy('trans_date', 'DESC')
        ->get();

        //dd($getTransaction);
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
        ->get();

        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        return view('body.customer.agencyTransaction', compact('TransactionData', 'customerData', 'countUnremitted'));
    }

    public function generateSchedule($id)
    {
        $getTransaction = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            //->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
            ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
            ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
            //->WHERE('teamID', '=', session('teamId'))
            ->WHERE('transaction_ref', '=', $id)
            ->orderBy('transaction_date', 'DESC')
        ->get();

        //dd($getTransaction);
        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
        ->get();

        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        return view('body.customer.generateSchedule', compact('getTransaction', 'customerData', 'countUnremitted'));
    }

    public function listAgencyMembers()
    {
        $teamData = DB::table('tbl_customer')
            ->WHERE('teamID', '=', session('teamId'))
            ->orderBy('date_added', 'DESC')
        ->get();

        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
        ->get();

        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        return view('body.customer.agencyList', compact('teamData', 'customerData', 'countUnremitted'));
    }

    public function addNewMember(request $request)
    {
        if (session('marineType')=="Known") {
                $marineType = "Known";
            }else{
                $marineType = "Unknown";
        }
        
        
        $unique = random_int(1000, 9999);
        $insertNewMember = DB::table('tbl_customer')->insert([
            'firstname' => $request->firstName,
            'lastname' => $request->lastName,
            'email' => $request->email,
            'telephone' => $request->phone,
            'password' => Hash::make($request->password),
            'teamID' => session('teamId'),
            'user_level'=> 3,
            'agent_unique_pin'=> $unique,
            'marine_team_type'=> $marineType,
            'date_added'=>now(),
        ]);

        if ($insertNewMember) {
            // $SendTeamMemberMail = (new MailController)->SendTeamMemberMail($request->firstName, $request->lastName, $request->email, $request->password, $unique);
            // dd($SendTeamMemberMail);
            return 'success';
        }else return 'error';

    }

    public function updateTransactionToken(request $request)
    {
        $updateCustomer = DB::table('tbl_customer')
                    ->where('customer_id', $request->textUserId)
                    ->update([
                        'agent_unique_pin' => $request->txtToken,
                    ]);

        if ($updateCustomer) {
            return 'success';
        }else return 'error';

    }

    public function teamtransactions()
    {
        $countUnremitted = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
            ->WHERE('teamID', '=', session('teamId'))
            ->WHERE('payment_statusID', '<>', 5)
        ->count();

        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
            ->get();

        // $TransactionData = DB::table('tbl_transaction')
        //     ->join(
        //         'tbl_order',
        //         'tbl_order.order_id',
        //         '=',
        //         'tbl_transaction.orderID'
        //     )->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
        //     ->join(
        //         'tbl_subpolicy',
        //         'tbl_subpolicy.upc',
        //         '=',
        //         'tbl_order.subPolicyID'
        //     )
        //     ->join(
        //         'tbl_policy',
        //         'tbl_policy.policy_id',
        //         '=',
        //         'tbl_subpolicy.policyID'
        //     )
        //     ->join(
        //         'tbl_order_status',
        //         'tbl_order_status.order_status_id',
        //         '=',
        //         'tbl_transaction.payment_statusID'
        //     )
        //     ->WHERE('teamID', '=', session('teamId'))
        //     ->WHERE('tbl_transaction.policy_number', '<>', NULL)
        //     ->orderByDesc('transaction_date')
        //     ->get();
        
        $TransactionData = DB::table('tbl_transaction')
            ->join('tbl_order', 'tbl_order.order_id', '=', 'tbl_transaction.orderID')
            ->join('tbl_customer', 'tbl_customer.customer_id', '=', 'tbl_order.customerID')
            ->join('tbl_subpolicy', 'tbl_subpolicy.upc', '=', 'tbl_order.subPolicyID')
            ->join('tbl_policy', 'tbl_policy.policy_id', '=', 'tbl_subpolicy.policyID')
            ->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_transaction.payment_statusID')
            ->WHERE('teamID', '=', session('teamId'))
            ->whereNotNull('tbl_transaction.policy_number')
            ->orderByDesc('tbl_transaction.transaction_date')
            ->get();


        return view('body.customer.teamtransactions', compact('customerData', 'TransactionData', 'countUnremitted'));
    }

    public function validateDate($date, $format = 'Y-m-d')
    {
        $d = DateTime::createFromFormat($format, $date);
        // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the comparison from == to === fixes the issue.
        return $d && $d->format($format) === $date;
    }

    public function teamtransactionsFilter(Request $request)
    {
        $TransactionData = [];
        $dateFrom = $this->validateDate($request->dateFrom);
        $dateTo = $this->validateDate($request->dateTo);
        
        //dd($request);
        
        if(session('userLevel') == "4"){
    
            if(!$dateFrom && !$dateTo){
                return view(
                    'body.customer.teamUnremittedAdmin',
                    compact('customerData', 'TransactionData')
                );
            }
            
            $customerData = DB::table('tbl_customer')
                ->WHERE('customer_id', '=', session('user_id'))
                ->get();
    
            if($dateFrom && $dateTo){
    
                $from = date($request->dateFrom);
                $to = date($request->dateTo);
                
                $getTransaction = DB::table('tbl_order') 
                    ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
                    ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
                    //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
                    ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
                    ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
                    ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
                    ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
                    ->WHERE('tbl_transaction.payment_statusID', '=', 1)
                    ->whereDate('tbl_transaction.transaction_date', '>=', $from)
                    ->whereDate('tbl_transaction.transaction_date', '<=', $to)
                    ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
                    ->orderBy('transaction_date', 'DESC')
                    ->get();
        
                $total = 0;
        
                for ($i = 0; $i < count($getTransaction); $i++) {
                    $ifExist = DB::table('tbl_team_has_policy_marine')
                        ->where('policyID', '=', $getTransaction[$i]->policy_id)
                        ->where('teamID', '=', $getTransaction[$i]->teamID)
                        ->get();
                
                    if (count($ifExist) > 0) {
                        // The $ifExist array has elements
                        $sum = (((100 - $ifExist[0]->premium_percentage) / 100) * $getTransaction[$i]->amount);
                        //$rrr[$i] = [$ifExist[0]->commission_percentage, $getTransaction[$i]->amount];
                    } else {
                        // The $ifExist array is empty
                        $sum = 0;
                    }
                
                    $total += $sum;
                }
        
                $getSum = DB::table('tbl_order')
                    ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
                    ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
                    //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
                    ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
                    ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
                    ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
                    ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
                    ->WHERE('tbl_transaction.payment_statusID', '=', 1)
                    ->whereDate('tbl_transaction.transaction_date', '>=', $from)
                    ->whereDate('tbl_transaction.transaction_date', '<=', $to)
                    ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
                    ->sum('amount');
        
                $countUnremitted = DB::table('tbl_order')
                    ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
                    ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
                    ->WHERE('tbl_transaction.payment_statusID', '=', 1)
                    ->whereDate('tbl_transaction.transaction_date', '>=', $from)
                    ->whereDate('tbl_transaction.transaction_date', '<=', $to)
                    ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
                    ->count();
    
            }
    
            if($dateFrom && !$dateTo){
                $from = date($request->dateFrom);
                
                $getTransaction = DB::table('tbl_order')
                    ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
                    ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
                    //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
                    ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
                    ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
                    ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
                    ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
                    ->WHERE('tbl_transaction.payment_statusID', '=', 1)
                    ->whereDate("tbl_transaction.transaction_date", "=", $from)
                    ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
                    ->orderBy('transaction_date', 'DESC')
                    ->get();
        
                $total = 0;
                //$rrr = [];
        
                for ($i = 0; $i < count($getTransaction); $i++) {
                    $ifExist = DB::table('tbl_team_has_policy_marine')
                        ->where('policyID', '=', $getTransaction[$i]->policy_id)
                        ->where('teamID', '=', $getTransaction[$i]->teamID)
                        ->get();
                
                    if (count($ifExist) > 0) {
                        // The $ifExist array has elements
                        $sum = (((100 - $ifExist[0]->premium_percentage) / 100) * $getTransaction[$i]->amount);
                        //$rrr[$i] = [$ifExist[0]->commission_percentage, $getTransaction[$i]->amount];
                    } else {
                        // The $ifExist array is empty
                        $sum = 0;
                    }
                
                    $total += $sum;
                }
        
                $getSum = DB::table('tbl_order')
                    ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
                    ->join('tbl_team','tbl_team.team_id','=','tbl_customer.teamID')
                    //->join('tbl_team_has_policy','tbl_team_has_policy.teamID','=','tbl_team.team_id')
                    ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
                    ->join('tbl_order_status','tbl_order_status.order_status_id','=','tbl_transaction.payment_statusID')
                    ->join('tbl_subpolicy','tbl_subpolicy.upc','=','tbl_order.subPolicyID')
                    ->join('tbl_policy','tbl_policy.policy_id','=','tbl_subpolicy.policyID')
                    ->WHERE('tbl_transaction.payment_statusID', '=', 1)
                    ->whereDate("tbl_transaction.transaction_date", "=", $from)
                    ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
                    ->sum('amount');
        
                $countUnremitted = DB::table('tbl_order')
                    ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
                    ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')
                    ->WHERE('tbl_transaction.payment_statusID', '=', 1)
                    ->whereDate("tbl_transaction.transaction_date", "=", $from)
                    ->whereIn('tbl_customer.teamID', [1, 2, 9, 10])
                    ->count();
                    
            }
    
            return view('body.customer.teamUnremittedAdmin', compact('getTransaction', 'customerData', 'countUnremitted', 'getSum', 'total'));
            
        }else{

            $customerData = DB::table('tbl_customer')
                ->WHERE('customer_id', '=', session('user_id'))
                ->get();
    
            if(!$dateFrom && !$dateTo){
                return view(
                    'body.customer.teamtransactions',
                    compact('customerData', 'TransactionData')
                );
            }
    
            if($dateFrom && $dateTo){
    
                $from = date($request->dateFrom);
                $to = date($request->dateTo);
    
                $TransactionData = DB::table('tbl_transaction')
                ->join(
                    'tbl_order',
                    'tbl_order.order_id',
                    '=',
                    'tbl_transaction.orderID'
                )->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_transaction.payment_statusID'
                )
                ->WHERE('teamID', '=', session('teamId'))
                ->whereBetween("tbl_transaction.transaction_date", [$from, $to])
                ->get();
    
            }
    
            if($dateFrom && !$dateTo){
                $from = date($request->dateFrom);
                $TransactionData = DB::table('tbl_transaction')
                ->join(
                    'tbl_order',
                    'tbl_order.order_id',
                    '=',
                    'tbl_transaction.orderID'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_transaction.payment_statusID'
                )
                ->WHERE('tbl_order.customerID', '=', session('user_id'))
                ->where("tbl_transaction.transaction_date", "=", $from)
                ->get();
            }
    
            return view(
                'body.customer.teamtransactions',
                compact('customerData', 'TransactionData')
            );
        }
    }
    
    public function updateAgentWalletPayment(request $request)
    {

        // if ($request->amount >= $request->walletBalance) {
        //     return json_encode(array('status' => 'error', 'message' => 'Insufficient Funds!'));
        // }
        $transaction_ref ='W'.$request->walletID.date('Y').date('d').date('hs').date('m');

        $updateAgencyTransaction = DB::table('tbl_agency_transaction')->insert([
            'teamID' => $request->teamId,
            'trans_reference' => $transaction_ref,
            'amount' => $request->amount,
            'trans_date' => now(),
        ]);

        $updateWalletTransaction = DB::table('tbl_wallet_transaction')->insert([
            'walletID' => $request->walletID,
            'transaction_reference' => $transaction_ref,
            'amount' => $request->amount,
            'transaction_description' => 'Payment of '.number_format($request->amount).' for bulk policies',
            'transaction_type' => 'Debit',
        ]);

        $updateWallet = DB::table('tbl_wallet')->where('wallet_id', $request->walletID)->update([
            'Balance' => $request->walletBalance - $request->amount,
        ]);

        $getTransaction = DB::table('tbl_order')
            ->join('tbl_customer','tbl_order.customerID','=','tbl_customer.customer_id')
            ->join('tbl_transaction', 'tbl_transaction.orderID', '=', 'tbl_order.order_id')

            ->WHERE('teamID', '=', $request->teamId)
            ->WHERE('payment_statusID', '<>', 5)
        ->get();


        foreach ($getTransaction as $trans) {
           //$updateAgencyTransaction =  DB::table('tbl_agency_transaction')->where('teamID', $vendor_id)->update(['order_statusID' => 5 ]);

           $updateTransaction = DB::table('tbl_transaction')->where('orderID', $trans->orderID)->update([
            'payment_statusID' => 5,
            'transaction_ref' => $transaction_ref,
            'payment_method' => 'Wallet',
            'transaction_date' => now()
        ]);
        //dd($updateTransaction);
        }

        if ($updateTransaction) {
            //return json_encode(array('status' => 'success', 'message' => 'Payment Successful'));
            return 'success';
        }

    }
}
