<?php

namespace App\Http\Controllers;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require base_path('vendor').'/phpmailer/phpmailer/src/PHPMailer.php';
require base_path('vendor').'/phpmailer/phpmailer/src/Exception.php';
require base_path('vendor').'/phpmailer/phpmailer/src/SMTP.php';



class MailController extends Controller
{


	/**
     * @param null
     * return json response if email was sent to provided email address
    **/
	public function sendTestMail()
	{
		$response = json_decode($this->sendEmail(['aisa@veritaskapital.com'], 'Test Subject', 'test Message'));
		
		dd($response);

        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}
	
	public function sendCustomerExpiry($data, $result)
	{
        //dd($data);
        //foreach ($data as $data) {
            $msg = "
            <h3>Dear $data->firstName,</h3>
            <p>Kindly be informed that your $data->policy_name with policy number $data->policy_number will expire in $result days . Click <a href='https://www.retail.veritaskapital.com/renewExpired/$data->order_id'>here</a> to renew.</p>
            <p>Thank you for choosing Veritas Kapital Assurance Plc.</p>
        ";
        //dd($msg);
        //}

		$response = json_decode($this->sendEmail([$data->email, 'aisa@veritaskapital.com', 'conaji@veritaskapital.com', 'retailsales@veritaskapital.com','Retail_Sales@veritaskapital.com'], 'Policy Expiry Notification', $msg));
		//$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'Policy Expiry Notification', $msg));
		//$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'Test Subject', 'test Message'));
        //dd($response);
        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}

    public function sendCustomerEmail($orderData, $insertIntoDB, $email)
	{
        //dd($orderData);
        foreach ($orderData as $data) {
            $houseHolderTerms = "";
            $cert_url = "https://www.retail.veritaskapital.com/certificate/$insertIntoDB";
            if ($orderData['0']->policyID === 2) {
                $houseHolderTerms = "<p>Please ensure to review the terms and condition for VKA house holder policy by clicking <a href='https://veritaskapital.com/terms_conditions/householder_terms.html'>here</a> </p>";
            }
            
            if ($orderData['0']->policyID === 6) {
                $cert_url = "".$orderData['0']->mapfre_certificate_url;
            }
            
            //return if system auto generates policy
            $msg = "
                <h3>Dear $data->firstName,</h3>
                <p>Your purchase was successful. Click <a href='".$cert_url."'>here</a> to download your policy certificate.</p>
                ".$houseHolderTerms."
                <p>Thank you for choosing Veritas Kapital Assurance plc.</p>
            ";
            
            //return if policy will be generated by vka and sent to agent
            // $msg = "
            //     <h3>Dear $data->firstName,</h3>
            //     <p>Your purchase was successful. You will receive your policy certificate in your email shortly.</p>
            //     ".$houseHolderTerms."
            //     <p>Thank you for choosing Veritas Kapital Assurance plc.</p>
            // ";
        }

		$response = json_decode($this->sendEmail([$email, 'Retail_Sales@veritaskapital.com'], 'On Your Policy Purchase', $msg));
		//$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'TEST: On Your Policy Purchase', $msg));

        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}
	
	public function sendWhatsappCustomerEmail($data, $id)
	{
        //dd($orderData);
        //foreach ($orderData as $data) {
            $houseHolderTerms = "";
            $cert_url = "https://www.retail.veritaskapital.com/certificatew/$id";
            
            $msg = "
                <h3>Dear $data->insured_name,</h3>
                <p>Your purchase was successful. Click <a href='".$cert_url."'>here</a> to download your policy certificate.</p>
                <p>Thank you for choosing Veritas Kapital Assurance plc.</p>
            ";
           
        //}

		$response = json_decode($this->sendEmail(['Retail_Sales@veritaskapital.com'], 'On Your Policy Purchase - W', $msg));
		//$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'TEST: On Your Policy Purchase', $msg));

        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}
	
	private function getAge($birthDate)
	{
	    return intval(date('Y', time() - strtotime($birthDate))) - 1970;
	}
	
	public function sendTravelInsuranceEmail($data, $email)
	{
        //dd($orderData);
        $age = $this->getAge($data->dob);
        $msg = "
        <h3>Dear Admin,</h3>
        <p>A policy has been purchased with the details below</p>
        <p></p>
        <p></p>
        <p>Policy: ".$data->subPolicy_name." (".$data->xml_suffijo.")</p>
        <p>Travel Start Date: ".date($data->departure_date)." </p>
        <p>Travel End Date: ".date($data->return_date)." </p>
        <p></p>
        <p>First Name: ".$data->firstName."</p>
        <p>Surname: ".$data->lastName."</p>
        <p>Email: ".$email."</p>
        <p>Date of Birth: ".$data->dob."</p>
        <p>Age: ".$age."</p>
        <p>Passport Number: ".$data->id_number."</p>
        <p>Destination Country: ".$data->dest_country."</p>
            
        ";
        

		//$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'Travel Insurance Policy Purchase', $msg));
		$response = json_decode($this->sendEmail(['retailsales@veritaskapital.com','Retail_Sales@veritaskapital.com'], 'Travel Insurance Policy Purchase', $msg));

        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}
	
	public function sendTravelInsuranceErrorEmail($data, $error_message)
	{
        //dd($orderData);
        $age = $this->getAge($data->dob);
        $msg = "
        <h3>Dear Admin,</h3>
        <p>A policy has been purchased with the details below and error encountered</p>
        <p></p>
        <p></p>
        <p>Policy: ".$data->subPolicy_name." (".$data->xml_suffijo.")</p>
        <p>Travel Start Date: ".date($data->departure_date)." </p>
        <p>Travel End Date: ".date($data->return_date)." </p>
        <p></p>
        <p>First Name: ".$data->firstName."</p>
        <p>Surname: ".$data->lastName."</p>
        <p>Email: ".$data->email."</p>
        <p>Date of Birth: ".$data->dob."</p>
        <p>Age: ".$age."</p>
        <p>Passport Number: ".$data->id_number."</p>
        <p>Destination Country: ".$data->dest_country."</p>
        <p>Error: ".$error_message."</p>
            
        ";
        

		//$response = json_decode($this->sendEmail(['ailiyasu@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'Travel Insurance Policy Purchase', $msg));
		$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'ERROR: Travel Insurance Policy Purchase', $msg));

        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}

    public function sendRetailEmail($orderData, $policyno, $eff_date, $end_date, $transRef, $amount)
	{
        //dd($orderData);
        foreach ($orderData as $data) {
            $msg = "
            <h3>Dear Team,</h3>
            <p>A new policy has been purchased with the following details:
                <table border='1' style='border: 1px solid;'>
                    <tr>
                        <td>Insured</td>
                        <td>$data->firstName $data->lastName </td>
                    </tr>
                    <tr>
                        <td>Address</td>
                        <td>$data->address</td>
                    </tr>
                    <tr>
                        <td>email</td>
                        <td>$data->email</td>
                    </tr>
                    <tr>
                        <td>Tel</td>
                        <td>$data->phone</td>
                    </tr>
                    <tr>
                        <td>Start Date</td>
                        <td>". date('Y-m-d H:i:s')."</td>
                    </tr>
                    <tr>
                        <td>End Date</td>
                        <td>$end_date</td>
                    </tr>
                    <tr>
                        <td>Product Name</td>
                        <td>$data->policy_name</td>
                    </tr>
                    <tr>
                        <td>Premium</td>
                        <td>$amount</td>
                    </tr>
                    <tr>
                        <td>Vehicle Make</td>
                        <td>$data->vehicle_make</td>
                    </tr>
                    <tr>
                        <td>Vehicle Model</td>
                        <td>$data->vehicle_model</td>
                    </tr>
                    <tr>
                        <td>Reg. Num</td>
                        <td>$data->car_reg_number</td>
                    </tr>
                    <tr>
                        <td>Policy Number</td>
                        <td>$policyno</td>
                    </tr>
                    <tr>
                        <td>Reference</td>
                        <td>$transRef</td>
                    </tr>
                </table>
            </p>
        ";
        }

		$response = json_decode($this->sendEmail(['retailsales@veritaskapital.com','Retail_Sales@veritaskapital.com','aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'New Policy Purchase', $msg));
		//$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'New Policy Purchase', $msg));

        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}
	
	public function sendNiidErrorEmail($data, $id)
	{
        //dd($data);
            $msg = "
            <h3>Dear Team,</h3>
            <p>A new policy has been purchased but failed to push to NIID</p>
            <p>Policy details:
                <table border='1' style='border: 1px solid;'>
                    <tr>
                        <td>Insured</td>
                        <td>$data->insured_name </td>
                    </tr>
                    <tr>
                        <td>Start Date</td>
                        <td>$data->eff_from_date</td>
                    </tr>
                    <tr>
                        <td>End Date</td>
                        <td>$data->eff_to_date</td>
                    </tr>
                    <tr>
                        <td>ID Ref</td>
                        <td>$id</td>
                    </tr>
                    <tr>
                        <td>Message</td>
                        <td>$data->niid_message</td>
                    </tr>
                </table>
            </p>
            <p>If policy does not exist, kindly click <a href='https://retail.veritaskapital.com/niidCustomerUpload/".$id."' style='font-size:2em; font-weight:700;'>HERE</a> to repush to NIID.</p>
        ";
        

		//$response = json_decode($this->sendEmail(['ailiyasu@veritaskapital.com', 'aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'NIID Policy Upload Error', $msg));
		//$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'Test Subject', 'test Message'));
		
		return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));

        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}
	
	public function SendCustomerResetPasswordMail($email, $randomString, $value)
	{
            $msg = "
                <h3>Dear $value->firstname $value->lastname,</h3>
                <p>Click <a href='retail.veritaskapital.com/resetPassword/$randomString'>here</a> to reset the password for your account on our retail website.</p>
                <p>Thank you for choosing Veritas Kapital Assurance Plc. We appreciate your trust in us.</p>
            ";

		$response = json_decode($this->sendEmail([$email], 'VKA:: Password Reset', $msg));
		//$response = json_decode($this->sendEmail(['aisa@veritaskapital.com', 'pbalarabe@veritaskapital.com'], 'VKA:: Successful Setup of Automatic Policy Renewals', $msg));

        if($response->status == "success"){
            return json_encode(array("status" => "success", "message" => "Mail Successfully sent"));
        }else{
            return json_encode(array("status" => "error", "message" => "Error sending reminder ".$response->message));
        }
	}


	/**
     * @param
     * return
    **/
	public function sendEmail($reciepients, $subject, $message)
	{

        $email_address = $reciepients[0];
		$mail = new PHPMailer(true);

	    try
	    {
	        $mail->IsSMTP();
            $mail->SMTPDebug = 0;
            $mail->SMTPAuth = true;
            $mail->SMTPSecure = "starttls";
            $mail->Port = 587;
            $mail->Username = "no_reply@veritaskapital.com";
            $mail->Password = "insurance@321";
            $mail->Host = "smtp.office365.com";
            $mail->SetFrom('no_reply@veritaskapital.com', 'Veritas Kapital Assurance');
            $mail->AddReplyTo($email_address, $email_address);
            $mail->AddAddress($email_address);
            $mail->Subject = ucwords($subject);
            $mail->WordWrap = 80;
            $mail->IsHTML(true);
            $mail->Body = $message;
			$mail->Debugoutput = function($str, $level) {echo "debug level $level; message: $str";};
			//$mail->Debugoutput = 'echo';

	        //$mail->MsgHTML($content);

            foreach($reciepients AS $addresses){
                $mail->AddCC($addresses, $addresses);
            }

            if (!$mail->Send())
            {
                return json_encode(array("status" => "error", "message" => "Problem in sending mail."));
            }
            else
            {
                return json_encode(array("status" => "success", "message" => "Email Successfully Sent"));
            }



	    }
	    // catch(phpmailerException $ep)
	    // {
	    //     //echo $e->errorMessage(); //Pretty error messages from PHPMailer
	    //     return json_encode(array("status" => "error", "message" => "".$ep->errorMessage()));
	    // }
	    catch(Exception $epp)
	    {
	        //echo $e->getMessage(); //Boring error messages from anything else!
	        return json_encode(array("status" => "error", "message" => "".$epp->getMessage()));
	    }
	}


}
