<?php

    namespace App\Http\Controllers;
    use Illuminate\Http\JsonResponse;
    
    class MapfreController extends Controller
    {
        
        private $soap_url;
		private $auth_user;
		private $auth_pass;
		private $auth_country;
		private $code_dealer;
		
		function __construct()
		{
			$this->soap_url = "https://warranty-neu.mia-assistance.com/wsWarranty4.asmx";
			$this->auth_user = "WSVKANG";
			$this->auth_pass = "hNEBKtnG27QO5GHyEzjzyPla9EQSc9ebl/cQnsLny7IQWeaTDmrC/rm0nB1zJzGDVJaIdY/rGXIfrh3znbwtBg==";
			$this->auth_country = "50";
			$this->code_dealer = "VKANG";
		}

		public function generateToken()
		{
			$curl = curl_init();

			curl_setopt_array($curl, array(
			  	CURLOPT_URL => ''.$this->soap_url,
			  	CURLOPT_RETURNTRANSFER => true,
			  	CURLOPT_ENCODING => '',
			  	CURLOPT_HEADER => false,
			  	CURLOPT_MAXREDIRS => 10,
			  	CURLOPT_TIMEOUT => 0,
			  	CURLOPT_FOLLOWLOCATION => true,
			  	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  	CURLOPT_CUSTOMREQUEST => 'POST',
			  	CURLOPT_POSTFIELDS =>'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:wws="http://wws.mapfreassistance.com/">
					   <soapenv:Header/>
					   <soapenv:Body>
					      <wws:login>
					         <!--Optional:-->
					         <wws:user>'.$this->auth_user.'</wws:user>
					         <!--Optional:-->
					         <wws:pass>'.$this->auth_pass.'</wws:pass>
					         <wws:country>'.$this->auth_country.'</wws:country>
					         <!--Optional:-->
					         <wws:remote_addr>?</wws:remote_addr>
					      </wws:login>
					   </soapenv:Body>
					</soapenv:Envelope>
				',
			  	CURLOPT_HTTPHEADER => array(
			  		"Cache-Control: no-cache",
			    	"Content-Type: text/xml"
			  	),
			));

			$response = curl_exec($curl);
			$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);

			if($httpcode !== 200)
			{
				return $this->errorResponse("Error code: ".$httpcode.". Failed to retrieve feed...");
			}

			$myXMLData = $response;

			$doc = new \DOMDocument();
			$doc->loadXML($myXMLData);
			$xpath = new \DOMXPath($doc);
			$xpath->registerNamespace('ns', 'http://schemas.xmlsoap.org/soap/envelope/'); 
			$description_tag = $xpath->query("//replay/description/text()")->item(0)->nodeValue;
			$status = $xpath->query("//replay/code/text()")->item(0)->nodeValue;

			if (strtolower($status) == "error") {

			  	return $this->errorResponse("Error: ".$response);

			}elseif (strtolower($status) == "ok") {

				$xml_list = simplexml_load_string($description_tag);
				if ($xml_list === false) {

				  	$dev_message = "";
				  	foreach(libxml_get_errors() as $error) {
				    	$dev_message .= "<br> ". $error->message;
				  	}

				  	return $this->errorResponse("Error ecountered while processing request", "Failed loading XML: ".$dev_message);
				} else {
					return $this->successResponse("Token Generated Successfully", (string)$xml_list->token);
				}

			} else {

				return $this->errorResponse("Request Failed ", $description_tag);

			}		
		}

		public function generatePolicy($params = array())
		{
			if(count($params) < 1){
				return $this->errorResponse("Error: Invalid Parameters Provided");
			}

			$curl = curl_init();

			curl_setopt_array($curl, array(
			  CURLOPT_URL => ''.$this->soap_url,
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'POST',
			  CURLOPT_POSTFIELDS =>'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:wws="http://wws.mapfreassistance.com/">
				    <soapenv:Header/>
				    <soapenv:Body>
				        <wws:issuing>
				            <!--Optional:-->
				            <wws:token>'.$params['auth_token'].'</wws:token>
				            <!--Optional:-->
				            <wws:xml>
				                <![CDATA[<root>
				            <policyData>
				                <contratoReplicadoV2>0</contratoReplicadoV2>
				                <txtPrecioBrutoTotal>0</txtPrecioBrutoTotal>
				                <txtNpoliza>AUTO</txtNpoliza>
				                <tipoPagador></tipoPagador>
				                <txtFhInicio>'.$params['travel_start_date'].'</txtFhInicio>
				                <!--policy start date-->
				                <txtFhFin>'.$params['travel_end_date'].'</txtFhFin>
				                <!--policy end date:-->
				                <txtProducto>'.$params['xml_product_code'].'</txtProducto>
				                <txtDivisaProducto/>
				                <idRegProducto>'.$params['xml_product_id'].'</idRegProducto>
				                <txtComentario />
				                <idRegFranquicia>-1</idRegFranquicia>
				                <idRegDivisaProducto />
				                <idRegRegion>-1</idRegRegion>
				                <txtFHExpiracion>'.$params['travel_end_date'].'</txtFHExpiracion>
				                <idRegProductoComisionVariable>-1</idRegProductoComisionVariable>
				                <txtCodDealer>'.$this->code_dealer.'</txtCodDealer>
				                <txtFhCambioDivisa />
				                <txtCodPromocion>-1</txtCodPromocion>
				                <txtSufijo>'.$params['xml_suffijo'].'</txtSufijo>
				                <txtDuracion>'.$params['travel_duration'].'</txtDuracion>
				            </policyData>
				            <riskData>
				                <CMBDESTINOSV>'.$params['xml_cmbdestinosv'].'</CMBDESTINOSV>
				                <txtPaisDestinois>
				                	<option>'.$params['travel_country_id'].'</option>
				                </txtPaisDestinois>
				            </riskData>
				            <insuredData>
				                <txtNmAsegurado>'.$params['customer_first_name'].'</txtNmAsegurado>
				                <txtApeAsegurado>'.$params['customer_last_name'].'</txtApeAsegurado>
				                <txtFhNacimiento>'.$params['customer_dob'].'</txtFhNacimiento>
				                <TXTEDADSV>'.$params['customer_age'].'</TXTEDADSV>
				                <txtIdFiscal>'.$params['customer_passport_number'].'</txtIdFiscal>
				                <txtTelefono>'.$params['customer_phone_number'].'</txtTelefono>
				            </insuredData>
				            <coberData>
				                '.$params['xml_cober_data'].'
				            </coberData>
				            <ecasData>
				                <cmbZona>-1</cmbZona>
				                <cmbPuntoVenta>-1</cmbPuntoVenta>
				                <cmbVendedor>-1</cmbVendedor>
				            </ecasData>
				            <tomadorData>
				                <txtNmAsegurado_policyHolder>'.$params['customer_first_name'].'</txtNmAsegurado_policyHolder>
				                <txtApeAsegurado_policyHolder>'.$params['customer_last_name'].'</txtApeAsegurado_policyHolder>
				                <txtFhNacimiento_policyHolder>'.$params['customer_dob'].'</txtFhNacimiento_policyHolder>
				                <TXTEDADSV_policyHolder>'.$params['customer_age'].'</TXTEDADSV_policyHolder>
				                <txtIdFiscal_policyHolder>'.$params['customer_passport_number'].'</txtIdFiscal_policyHolder>
				                <txtTelefono_policyHolder>'.$params['customer_phone_number'].'</txtTelefono_policyHolder>
				                <cmbTpPersona_policyHolder>1</cmbTpPersona_policyHolder>
				            </tomadorData>
				            <parameters>
				                <action>A</action>
				                <posicionTomador>1</posicionTomador>
				            </parameters></root>]]>
				        </wws:xml>
				    </wws:issuing>
				</soapenv:Body>
				</soapenv:Envelope>',
			  CURLOPT_HTTPHEADER => array(
			    'Content-Type: text/xml'
			  ),
			));

			$response = curl_exec($curl);
			$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);

			if($httpcode !== 200)
			{
				return $this->errorResponse("Error code: ".$httpcode.". Failed to retrieve feed...");
			}

			$myXMLData = $response;

			$doc = new \DOMDocument();
			$doc->loadXML($myXMLData);
			$xpath = new \DOMXPath($doc);
			$xpath->registerNamespace('ns', 'http://schemas.xmlsoap.org/soap/envelope/'); 

			$description_tag = $xpath->query("//replay/description/text()")->item(0)->nodeValue;
			$status = $xpath->query("//replay/code/text()")->item(0)->nodeValue;
			$response = htmlentities($description_tag);

			if (strtolower($status) == "error") {
			  	
				return $this->errorResponse("Error: ".$response);

			}elseif (strtolower($status) == "ok") {

				$cert_url = $this->getStringpart($response, "http", "&lt;/file&gt");
				$cert_id = $this->getIdStringpart($response, "&lt;idRegContrato&gt;", "&lt;/idRegContrato&gt;");
				
				return $this->successResponse("Policy Generated Successfully", $response);

			} else {
				return $this->errorResponse("Error encountered while Generating Certificate. Try again ", $description_tag);
			}
		}
		
		public function printCertificate($params = array())
		{
		    if(count($params) < 1){
				return $this->errorResponse("Error: Invalid Parameters Provided");
			}
			
			$curl = curl_init();
			
			curl_setopt_array($curl, array(
              CURLOPT_URL => ''.$this->soap_url,
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS =>'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:wws="http://wws.mapfreassistance.com/">
                       <soapenv:Header/>
                       <soapenv:Body>
                          <wws:printCertificate>
                             <!--Optional:-->
                             <wws:token>'.$params['auth_token'].'</wws:token>
                             <!--Optional:-->
                             <wws:certificateID>'.$params['certificate_id'].'</wws:certificateID>
                          </wws:printCertificate>
                       </soapenv:Body>
                    </soapenv:Envelope>',
              CURLOPT_HTTPHEADER => array(
                'Content-Type: text/xml'
              ),
            ));

			$response = curl_exec($curl);
			$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			curl_close($curl);

			if($httpcode !== 200)
			{
				return $this->errorResponse("Error code: ".$httpcode.". Failed to retrieve feed...");
			}

			$myXMLData = $response;
			
			// Define the prefix you want to check against
            $prefix = "https://warranty-neu.mia-assistance.com/temp/";
            
            // Check if the string starts with the specified prefix
            if (strpos($response, $prefix) === 0) {
                //"The string starts with the specified prefix.";
                return $this->successResponse("Certificate Generated Successfully", (string)$response);
            } else {
                //"The string does not start with the specified prefix.";
                return $this->errorResponse("Error ecountered while processing request", "Failed loading XML: ".$response);
            }

		}

		public function getStringpart($string, $startStr, $endStr) 
		{
			$startpos=strpos($string,$startStr);
			$endpos=strpos($string,$endStr,$startpos);
			$endpos=$endpos-$startpos;
			$string=substr($string,$startpos,$endpos);

			return $string;
		}
		
		public function getIdStringpart($string, $startStr, $endStr) 
    	{
    	    $startpos = strpos($string, $startStr);
    	    if ($startpos !== false) {
    	        $startpos += strlen($startStr); // Move the start position to the end of the start string
    	        $endpos = strpos($string, $endStr, $startpos);
    	        if ($endpos !== false) {
    	            $string = substr($string, $startpos, $endpos - $startpos);
    	            return $string;
    	        }
    	    }
    	    return false;
    	}

		/**
	     * Format and return error response
	     *
	     * @param string $message
	     * @param int $code
	     * @return JsonResponse
	     */
	    protected function errorResponse($message, $dev_info = null, $code = 400): JsonResponse
	    {
	        return response()->json([
	            'status' => 'error',
	            'message' => $message,
	            'developer_info' => $dev_info
	        ], $code);
	    }

	    /**
	     * Format and return success response
	     *
	     * @param  string  $message
	     * @param  array|string  $data
	     * @param  int  $code
	     * @return JsonResponse
	     */
	    protected function successResponse($message = '', $data = '', $code = 200): JsonResponse
	    {
	        $response = ['status' => 'success'];

	        if ($message != '') {
	            $response['message'] = $message;
	        }

	        if ($data != '') {
	            $response['data'] = $data;
	        }

	        return response()->json($response, $code);
	    }
        
    }