<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class PaystackDirectDebitController extends Controller
{
    protected $secretKey;

    public function __construct()
    {
        // Set your Paystack secret key here
        $this->secretKey = env('PAYSTACK_SECRET_KEY');
    }

    public function initiateAuthorization(Request $request)
    {
        // Endpoint for initiating an authorization request
        $url = 'https://api.paystack.co/customer/authorization/initialize';

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->secretKey,
            'Cache-Control' => 'no-cache',
        ])->post($url, [
            'email' => $request->email,
            'channel' => $request->channel,
            'callback_url' => $request->callback_url,
            // 'account' => [
            //     "number"=> $request->account_number,
            //     "bank_code"=> $request->bank_code
            // ],
            // "address"=> [
            //     "state"=> $request->state,
            //     "city"=> $request->city,
            //     "street"=> $request->street
            // ]
        ]);

        return $response->json();
    }

    public function verifyAuthorization($reference)
    {
        // Endpoint for verifying authorization status
        $url = "https://api.paystack.co/customer/authorization/verify/{$reference}";

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->secretKey,
            'Cache-Control' => 'no-cache',
        ])->get($url);

        return $response->json();
    }

    public function chargeAccount(Request $request)
    {
        // Endpoint for charging the account
        $url = 'https://api.paystack.co/transaction/charge_authorization';

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->secretKey,
            'Cache-Control' => 'no-cache',
        ])->post($url, [
            'authorization_code' => $request->authorization_code, // Replace with actual authorization code
            'email' => $request->email,
            'amount' => $request->amount,
            'currency' => 'NGN',
        ]);

        return $response->json();
    }

    public function verifyCharge($reference)
    {
        // Endpoint for verifying a charge
        $url = "https://api.paystack.co/transaction/verify/{$reference}";

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->secretKey,
            'Cache-Control' => 'no-cache',
        ])->get($url);

        return $response->json();
    }

    public function deactivateAuthorization(Request $request)
    {
        // Endpoint for deactivating authorization
        $url = 'https://api.paystack.co/customer/authorization/deactivate';

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->secretKey,
            'Cache-Control' => 'no-cache',
        ])->post($url, [
            'authorization_code' => $request->authorization_code, // Replace with actual authorization code
        ]);

        return $response->json();
    }
}
