<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;

class PolicyExpiryController extends Controller
{
    public function getExpiredPolicy()
    {
        $year = date('Y');
        $orderData = DB::table('tbl_order')
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_transaction',
                'tbl_transaction.orderID',
                '=',
                'tbl_order.order_id'
            )->whereYear('eff_to_date', $year)->where('policyID','<>',6)
        ->get();
       //dd($orderData);

        $today = date('Y-m-d');
        $date_now = strtotime($today); // or your date as well

        foreach ($orderData as $data) {
            //echo $data->phone.'<br/><br/>';
            
            $last_changed_date = strtotime($data->eff_to_date);
            $datediff = $date_now - $last_changed_date;
            $result =  round($datediff / (60 * 60 * 24));
            //dd($result);
            if ($result <= 15 && $result >=1 ) {
                //dd($data);
                
                $sendCustomerEmail = (new MailController)->sendCustomerExpiry($data, $result);
                $msg = "Your $data->policy_name policy expire in $result days. Click https://www.retail.veritaskapital.com/renewExpired/$data->order_id to renew.";
                $sendCustomerSms = (new SmsController)->sendSms($msg, $data);
            }
            // if ($result <= 15 && $result >=1 && strlen($data->phone) == 10 && is_numeric($data->phone) ) {
            //     $msg = "Your $data->policy_name policy expire in $result days. Click https://www.retail.veritaskapital.com/renewExpired/$data->order_id to renew.";
            //     $sendCustomerSms = (new SmsController)->sendSms($msg, $data);
            // }
        }
    }

    public function renewExpiredPolicy($id)
    {
        $orderData = DB::table('tbl_order')
        ->join(
            'tbl_subpolicy',
            'tbl_subpolicy.upc',
            '=',
            'tbl_order.subPolicyID'
        )
        ->join(
            'tbl_policy',
            'tbl_policy.policy_id',
            '=',
            'tbl_subpolicy.policyID'
        )
        ->join(
            'tbl_transaction',
            'tbl_transaction.orderID',
            '=',
            'tbl_order.order_id'
        )->where('order_id', '=', $id)
    ->get();
    return view('body.confirmCheckout', compact('orderData'));
    }
    
    public function UpdateNumberWhatsapp()
    {
        $orderData = DB::table('tbl_order')
        ->where('sale_channel', '=', 'WhatsApp')
        //->where('order_id', '=', 635)
        ->get();
        //dd($orderData);

        foreach ($orderData as $data) {

            $phone = trim($data->id_number);
            $newPhone = ltrim($phone,'0');

            $updatequery = DB::table('tbl_order')
                    ->where('order_id', $data->order_id)
                    ->update(['phone' => $newPhone]);

        }
    }
    
}
