<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Http;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;

class RenewalController extends Controller
{
    protected $secretKey;

    public function __construct()
    {
        // Set your Paystack secret key here
        $this->secretKey = env('PAYSTACK_SECRET_KEY');
    }
    
    private function getVehicleMakeName($stuff)
    {
        $get = DB::table('tbl_niip_vehicle_make')
            ->where('make', 'LIKE', '%' . $stuff . '%')
        ->first();

        if ($get) {
            return $get->code;
        }else{
            return NULL;
        }

    }

    private function getVehicleModelName($stuff)
    {
        $get = DB::table('tbl_niip_vehicle_model')
            ->where('model', 'LIKE', '%' . $stuff . '%')
        ->first();

        if ($get) {
            return $get->code;
        }else{
            return NULL;
        }

    }

    private function getVehicleColourName($stuff)
    {
        $get = DB::table('tbl_niip_vehicle_colour')
            ->where('colour', 'LIKE', '%' . $stuff . '%')
        ->first();

        if ($get) {
            return $get->code;
        }else{
            return NULL;
        }

    }

    private function getVehicleCapacityName($stuff)
    {
        $get = DB::table('tbl_niip_engine_capacity')
            ->where('capacity', 'LIKE', '%' . $stuff . '%')
        ->first();

        if ($get) {
            return $get->code;
        }else{
            return NULL;
        }

    }

    private function getStateName($stuff)
    {
        $get = DB::table('tbl_niip_state')
            ->where('state', 'LIKE', '%' . $stuff . '%')
        ->first();

        if ($get) {
            return $get->code;
        }else{
            return NULL;
        }

    }

    private function getLgaName($stuff)
    {
        $get = DB::table('tbl_niip_lga')
            ->where('lga', 'LIKE', '%' . $stuff . '%')
        ->first();
        if ($get) {
            return $get->code;
        }else{
            return NULL;
        }

    }
    
    //
    public function renewal()
    {
        return view('body.renewals');
    }

    public function verifyRenewal(request $request)
    {
        //dd($request);
        // $request->validate([
        //     'renewal_ID' => 'required|min:5|max:20'
        // ]);
        //dd($request->renewal_ID); exit();
        
        $renewal_id = trim($request->renewal_ID);
        
        // $ifExist = DB::select(DB::RAW("select * from tbl_order
        //                             inner join tbl_transaction on tbl_order.order_id = tbl_transaction.orderID 
        //                             inner join tbl_subpolicy on tbl_subpolicy.upc = tbl_order.subPolicyID
        //                             inner join tbl_policy on tbl_policy.policy_id = tbl_subpolicy.policyID
        //                             WHERE TRIM(tbl_order.car_reg_number) = '".$renewal_id."'"
        //                         )
        //                 );
        //dd($ifExist);

      $ifExist = DB::table('tbl_order')
        ->join(
            'tbl_transaction',
            'tbl_order.order_id',
            '=',
            'tbl_transaction.orderID'
        )
        ->join(
            'tbl_subpolicy',
            'tbl_subpolicy.upc',
            '=',
            'tbl_order.subPolicyID'
        )
        ->join(
            'tbl_policy',
            'tbl_policy.policy_id',
            '=',
            'tbl_subpolicy.policyID'
        )
        
        ->WHERE('tbl_order.car_reg_number', '=', $renewal_id)
        ->ORWHERE('tbl_transaction.policy_number', '=', $renewal_id)
        //->WHERE('tbl_transaction.payment_statusID', '=', 5)
        //->Where(DB::RAW(TRIM('tbl_order.car_reg_number')), '=', $renewal_id)
        ->WHERE('tbl_transaction.payment_statusID', '=', 5)
        ->orderBy('transaction_date', 'desc')
        ->limit(1)
        ->get();
        //->toArray();

       //dd($ifExist);

       if(count($ifExist) < 1){
        return back()->with('verifyError', 'Record Not Found!');
        }
        // elseif($ifExist[0]->payment_statusID !== 5){
        // return back()->with('verifyError', 'Entry does not exist on our servers!');
        // }
        else{
        $request->session()->put('orderID', $ifExist['0']->order_id);
        return back()->with(['verifySuccess'=> 'Record Found!', 'policy_number' => $ifExist['0']->policy_number, 'firstName' => $ifExist['0']->firstName,
        'lastName' => $ifExist['0']->lastName, 'premium' => $ifExist['0']->amount, 'policy_name' => $ifExist['0']->policy_name, 'expiry' => $ifExist['0']->eff_to_date]);
        }

    }
    
    public function confirmRenewal()
    {
        //dd('ok');
        
        $orderData = DB::table('tbl_order')
                ->join(
                    'tbl_customer',
                    'tbl_order.customerID',
                    '=',
                    'tbl_customer.customer_id'
                )
                ->join(
                    'tbl_subpolicy',
                    'tbl_subpolicy.upc',
                    '=',
                    'tbl_order.subPolicyID'
                )
                ->join(
                    'tbl_policy',
                    'tbl_policy.policy_id',
                    '=',
                    'tbl_subpolicy.policyID'
                )
                ->join(
                    'tbl_order_status',
                    'tbl_order_status.order_status_id',
                    '=',
                    'tbl_order.order_statusID'
                )
                ->WHERE('order_id', '=', session('orderID'))
                ->first();
                
                if (($orderData->policy_id ?? null) == 3) {
                    //check if data already exists on NIIP table
                    $getNIID = DB::table('tbl_niip_upload')
                        ->where('orderID', session('orderID'))
                        ->orderBy('created_at', 'DESC')
                    ->first();
                    
                    if($getNIID){
                        $y = DB::table('tbl_niip_upload')->insert([
                            'orderID' => session('orderID'),
                            'first_name' => $getNIID->first_name,
                            'last_name' => $getNIID->last_name,
                            'phone_number' => $getNIID->phone_number,
                            'email_address' => $getNIID->email_address,
                            'nin' => $getNIID->nin,
                            'engine_capacity' => $getNIID->engine_capacity,
                            'vehicle_make' => $getNIID->vehicle_make,
                            'vehicle_model' => $getNIID->vehicle_model,
                            'engine_no' => $getNIID->engine_no,
                            'reg_no' => $getNIID->reg_no,
                            'chasis_no' => $getNIID->chasis_no,
                            'state' => $getNIID->state,
                            'lga' => $getNIID->lga,
                            'vehicle_colour' => $getNIID->vehicle_colour,
                            'address' => $getNIID->address,
                            'purpose' => $getNIID->purpose,
                
                        ]);
                        
                    }else{
                        //dd($orderData);
                        $PolicyController = new PolicyController();
                        $vehiclemake = $this->getVehicleMakeName($orderData->vehicle_make);
                        $vehiclemodel = $this->getVehicleModelName($orderData->vehicle_model);
                        $vehiclecolour = $this->getVehicleColourName($orderData->colour);
                        $state = 15;
                        $lga = 274;
                        
                        switch ($orderData->subPolicyID) {
                            case '010102':
                                $purposeID = 3;
                                break;
                            case '010202':
                                $purposeID = 8;
                                break;
                            case '010403':
                                $purposeID = 4;
                                break;
                            case '010402':
                                $purposeID = 7;
                                break;
                            case '010205':
                                $purposeID = 5;
                                break;
                            case '010203':
                                $purposeID = 9;
                                break;
                            default:
                                $purposeID = 3;
                                break;
                        }
                        
                        $y = DB::table('tbl_niip_upload')->insert([
                            'orderID' => session('orderID'),
                            'first_name' => $orderData->firstName,
                            'last_name' => $orderData->lastName,
                            'phone_number' => $orderData->phone,
                            'email_address' => $orderData->email,
                            'nin' => $orderData->id_number,
                            'engine_capacity' => 2,
                            'vehicle_make' => $vehiclemake,
                            'vehicle_model' => $vehiclemodel,
                            'engine_no' => $orderData->car_reg_number,
                            'reg_no' => $orderData->car_reg_number,
                            'chasis_no' => $orderData->chasis_number,
                            'state' => $state,
                            'lga' => $lga,
                            'vehicle_colour' => $vehiclecolour,
                            'address' => $orderData->address,
                            'purpose' => $purposeID,
                
                        ]);
                        
                    }
                }
        
        if (session('user_id')) {
            //if user already logged in, update tbl_order and set customerID, also fetch records to be displayed in confirm checkout.
            $updatequery = DB::table('tbl_order')
                ->where('order_id', session('orderID'))
                ->update(['customerID' => session('user_id')]);
            //var_dump($updatequery); exit();
            
            $getWallet = DB::table('tbl_wallet')
            ->WHERE('customerID', '=', session('user_id'))
            ->first();
            

            return view('body.confirmCheckout', compact('orderData', 'getWallet'));
            
        } else {
            return redirect()->action([
                PolicyController::class,
                'checkoutPage',
            ]);
        }

    }
    
    //Autorenewal Begins Here
    public function autorenewalsetup(Request $request)
    {
        $url = 'https://api.paystack.co/customer/authorization/initialize';

        $fields = [
            'email' => $request->email,
            'channel' => 'direct_debit',
            'callback_url' => 'http://127.0.0.1:8086/auto/renewal/response',
        ];
        $fields_string = http_build_query($fields);

        //open connection
        $ch = curl_init();

        //set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer sk_test_ed0517bf606e293e42e1e61bfb5b32455e1950e1',
            'Cache-Control: no-cache',
        ]);

        //So that curl_exec returns the contents of the cURL; rather than echoing it
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $execute = curl_exec($ch);

        $result = json_decode($execute);

        $request->session()->put('reference', $result->data->reference);

        if ($result->status == 'true') {
            DB::table('tbl_dd_auth')->insert([
                'customerID' => $request->userID,
                'access_code' => $result->data->access_code,
                'reference' => $result->data->reference,
                //'auth_request_status' => $result->status,
            ]);

            //dd($result->data->redirect_url);

            return $result->data->redirect_url;
            //return return redirect()->action('${App\Http\Controllers\HomeController@index}', ['parameterKey' => 'value']);
        } else {
            return 'failed' . $result->message;
        }
    }

    public function autorenewalrsetupesponse(Request $request)
    {
        $reference = session('reference');

        $response = (new PaystackDirectDebitController())->verifyAuthorization(
            $reference
        );

        if ($response['status'] === false) {
            $message = $response['status'];
            DB::table('tbl_dd_auth')
                ->where('auth_id', $reference)
                ->update([
                    'auth_request_status' => $response['status'],
                ]);
        } elseif ($response['status'] === true) {
            $message = $response['status'];
            DB::table('tbl_dd_auth')
                ->where('auth_id', $reference)
                ->update([
                    'auth_request_status' => $response['status'],
                ]);
        }

        $customerData = DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
            ->get();

        session()->pull('reference');

        return view(
            'body.customer.autorenewals',
            compact('customerData', 'message')
        );
    }

    public function authVerification(Request $request)
    {
        $getDD = DB::table('tbl_dd_auth')->get();

        foreach ($getDD as $value) {
            $response = (new PaystackDirectDebitController())->verifyAuthorization(
                $value->reference
            );

            // Check the status in the decoded array
            if ($response['status'] === false) {
                DB::table('tbl_dd_auth')
                    ->where('auth_id', $value->auth_id)
                    ->update([
                        'auth_request_status' => $response['status'],
                    ]);
            } elseif (
                $response['status'] === true &&
                $response['data']['active'] === false
            ) {
                DB::table('tbl_dd_auth')
                    ->where('auth_id', $value->auth_id)
                    ->update([
                        'auth_request_status' => $response['status'],
                        'auth_active_status' => $response['data']['active'],
                    ]);
            } elseif (
                $response['status'] === true &&
                $response['data']['active'] === true
            ) {
                DB::table('tbl_dd_auth')
                    ->where('auth_id', $value->auth_id)
                    ->update([
                        'auth_request_status' => $response['status'],
                        'auth_active_status' => $response['data']['active'],
                        'auth_code' => $response['data']['authorization_code'],
                        'customer_code' =>
                            $response['data']['customer']['code'],
                    ]);

                // Optionally send an email notification
                (new MailController())->SendDirectDebitAuthToCustomer(
                    $response['data']['customer']['email'],
                    $response['data']['account_name']
                );

                echo 'record updated';
            }
        }
    }

    public function getDirectDebitRecords()
    {
        //$from = Carbon::parse($from)->startOfDay();
        $orderData = DB::table('tbl_order')
            ->join(
                'tbl_customer',
                'tbl_customer.customer_id',
                '=',
                'tbl_order.customerID'
            )
            ->join(
                'tbl_dd_auth',
                'tbl_dd_auth.customerID',
                '=',
                'tbl_customer.customer_id'
            )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            ->join(
                'tbl_transaction',
                'tbl_transaction.orderID',
                '=',
                'tbl_order.order_id'
            )
            ->where('tbl_transaction.payment_statusID', '=', 5)
            ->whereDate('tbl_transaction.eff_to_date', '=', date('Y-m-d'))
            ->get();

            //dd($orderData);


        foreach ($orderData as $value) {
            if ($value->auth_active_status == '' || $value->auth_active_status == 0) {

                (new MailController())->SendDDDeactivateToCustomer($value->email, $value);

            }else{

                // Endpoint for charging the account
                $url = 'https://api.paystack.co/transaction/charge_authorization';

                $charge = Http::withHeaders([
                    'Authorization' => 'Bearer ' . $this->secretKey,
                    'Cache-Control' => 'no-cache',
                ])->post($url, [
                    'authorization_code' => $value->auth_code, // Replace with actual authorization code
                    'email' => $value->email,
                    'amount' => $value->amount,
                    'currency' => 'NGN',
                ]);

                $charge_response = $charge->json();

                $response = (new PaystackDirectDebitController())->verifyCharge($charge_response['data']['reference']);

                //dd($response);

                if ($response['status'] === true) {

                    DB::table('tbl_dd_transaction')->insert([
                        'customer' => $value->customer_id,
                        'paystack_id' => $response['data']['id'],
                        'reference' => $response['data']['reference'],
                        'receipt_number' => $response['data']['receipt_number'],
                        'status' => $response['status'],
                        'message' => $response['message'],
                        'data_message' => $response['data']['message'],
                        'amount' => $response['data']['amount'],
                    ]);


                    //upload to NAICOM and NIIP
                    $param["sid_live"] = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
                    $param["token_live"] = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
                    $param["sid_test"] = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
                    $param["token_test"] = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
                    $param["companyType"] = 'G';
                    $param["companyId"] = '74';
                    $param["means_of_id"] = 'PASSPORT';
                    $param["means_of_id_number"] = $value->id_number ?? '123456789';
                    $param["phone"] = trim($value->phone) ?: '+234(0)700 1000 500';
                    // First, create the effective date in a format strtotime can work with
                    $effective_date_timestamp = strtotime("+1 day", strtotime($value->eff_to_date));
                    $param["effective_date"] = date('m/d/Y H:i:s A', $effective_date_timestamp);
                    // Then, add 365 days to the effective date and format it
                    $expiration_date_timestamp = strtotime("+365 days", $effective_date_timestamp);
                    $param["expiration_date"] = date('m/d/Y H:i:s A', $expiration_date_timestamp);
                    $param["premium"] = $value->subPolicy_price;
                    $param["product_name"] = $value->policy_name;
                    $param["policy_number"] = $value->policy_number;
                    $param["sum_insured"] = $value->sum_insured;
                    $param["registration_number"] = $value->car_reg_number;
                    $param["email"] = trim($value->email) ?: 'info@veritaskapital.com';
                    $param["insured"] = $value->firstName . ' ' . $value->lastName;
                    $param["last_name"] = $value->lastName;
                    $param["vehicle_make"] = $value->vehicle_make;
                    $param["vehicle_model"] = $value->vehicle_model;
                    $param["product_class"] = $value->policyID;
                    $param["covertType"] = 'THIRD_PARTY';
                    $param["niidcovertType"] = NULL;
                    $param["today_date"] = NULL;
                    $param["end_date"] = NULL;
                    $param["dob"] = NULL;
                    $param["address"] = $value->address;
                    $param["gender"] = NULL;
                    $param["vessel_make_model"] = NULL;
                    $param["vessel_reg_number"] = NULL;
                    $param["vessel_type"] = NULL;
                    $param["vessel_purchase_value"] = NULL;
                    $param["vessel_insured_value"] = NULL;
                    $param["type_of_goods"] = NULL;
                    $param["transit_method"] = NULL;
                    $param["transit_v_info"] = NULL;
                    $param["api_sum_insured"] = NULL;
                    $param["amount"] = NULL;


                    $uploadToNaicom = (new ApiNaicomUpload)->uploadToNaicom($param);

                    //dd($uploadToNaicom['naicomUid']);

                    if ($value->policyID===3) {

                        // Step 1: Retrieve the record by its ID
                        $record = DB::table('tbl_niip_upload')->where('orderID', $value->order_id)->first();

                        if ($record) {
                            // Convert the retrieved record to an array
                            $newRecord = (array) $record;

                            // Step 2: Remove the primary key to avoid conflict (assuming 'id' is the primary key)
                            unset($newRecord['upload_id']);

                            // Optional: Modify other fields if needed before re-uploading
                            // For example, update timestamps or some other field
                            $newRecord['eff_from_date'] = null;
                            $newRecord['created_at'] = now();
                            $newRecord['updated_at'] = now();
                            $newRecord['is_success'] = null;
                            $newRecord['message'] = null;

                            // Step 3: Insert the duplicated record into the table
                            DB::table('tbl_niip_upload')->insert($newRecord);

                            $uploadToNiid = (new NiipController)->niipUpload($value->customerID, $value->orderID, $value->policy_number, date('Y/m/d', $effective_date_timestamp), $uploadToNaicom['naicomUid']);
                        }

                    }

                    if ($uploadToNaicom) {

                        $transaction = DB::table('tbl_transaction')->insertGetId([
                            'orderID' => $value->orderID,
                            'transaction_ref' => $response['data']['reference'],
                            'payment_method' => 'PAYSTACK DD',
                            'payment_statusID' => 5,
                            'amount' => $response['data']['amount'],
                            'transaction_date' => now(),
                            'policy_number' => $value->policy_number,
                            'naicom_uid' => $uploadToNaicom['naicomUid'],
                            'eff_from_date' => date('Y/m/d', $effective_date_timestamp),
                            'eff_to_date' => date('Y/m/d', $expiration_date_timestamp),
                        ]);

                        (new MailController())->SendSuccessfulPolicyToCustomer($value->email, $value, $transaction);
                    }


                } else{

                    DB::table('tbl_dd_transaction')->insert([
                        'customer' => $value->customer_id,
                        // 'paystack_id' => $response['data']['id'],
                        // 'reference' => $response['data']['reference'],
                        // 'receipt_number' => $response['data']['receipt_number'],
                        'status' => $response['status'],
                        'message' => $response['message'],
                        // 'data_message' => $response['data']['message'],
                        // 'amount' => $response['data']['amount'],
                    ]);
                    (new MailController())->SendChargeFailureToCustomer($value->email, $value);
                }


            }
        }
    }

    public function deactivateDD(Request $request)
    {
        $getDD = DB::table('tbl_dd_auth')->where('customerID', $request->customerID)->first();
        if ($getDD) {

            $url = 'https://api.paystack.co/customer/authorization/deactivate';

            $deactivate = Http::withHeaders([
                'Authorization' => 'Bearer ' . $this->secretKey,
                'Cache-Control' => 'no-cache',
            ])->post($url, [
                'authorization_code' => $getDD->auth_code, // Replace with actual authorization code
            ]);

            $deactivate_response = $deactivate->json();

            if ($deactivate_response['status'] == true) {

                $updatequery = DB::table('tbl_dd_auth')
                ->where('customerID', $request->customerID)
                ->update(['auth_active_status' => $deactivate_response['status'],
                        'deactive_category' => $request->reason_category,
                        'deactive_message' => $request->reason,
                ]);
                response()->json(['status' => 'success', 'message' => $deactivate_response['message']]);

            }else{

                return response()->json(['status' => 'failed', 'message' => $deactivate_response['message']]);

            }


        } else{

            return response()->json(['status' => 'failed', 'message' => 'You are not subscribed to for autorenewal']);
        }


    }
    
    
}
