<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class WalletController extends Controller
{
    public function manageWallet()
    {
        $getWallet = DB::table('tbl_wallet')
            ->WHERE('customerID', '=', session('user_id'))
        ->first();

        $getWalletDetails = DB::table('tbl_wallet_transaction')
            ->join('tbl_wallet','tbl_wallet_transaction.walletID','=','tbl_wallet.wallet_id')
            ->WHERE('tbl_wallet.customerID', '=', session('user_id'))
            ->orderBy('Timestamp', 'DESC')
        ->get();

        $customerData= DB::table('tbl_customer')
            ->WHERE('customer_id', '=', session('user_id'))
        ->get();

        //dd($customerData);


        return view('body.customer.wallet', compact('getWallet','getWalletDetails', 'customerData'));

    }

    public function verifyPayment($reference, $vendor_id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/".$reference,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer sk_test_ed0517bf606e293e42e1e61bfb5b32455e1950e1",
                "Cache-Control: no-cache",
            ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        if ($err) {
            return json_encode(array('status' => 'error', 'message' => 'Error Encountered', 'dev_message' => 'cURL Error #:' . $err.''));
        } else {
            $json_response = json_decode($response);
            //dd($json_response);
            if($json_response->status && $json_response->data->status == 'success'){
                $amount = $json_response->data->amount/100;
                $update_response = $this->updateWalletPayments($vendor_id, $json_response->data->reference, $amount);
                //$update_response = json_decode($update_response);

                return $update_response;
            }else{
                return $json_response->message;
            }
        }
    }

    public function updateWalletPayments($vendor_id, $transaction_id, $amount_paid)
    {
        // Check if the vendor has an existing wallet
        $wallet = DB::table('tbl_wallet')
            ->where('customerID', $vendor_id)
            ->first();

        // Calculate the new balance after deducting a fee
        $new_balance = $amount_paid - 100;

        // If the vendor doesn't have a wallet, create a new one
        if (!$wallet) {
            $walletID = DB::table('tbl_wallet')->insertGetId([
                'customerID' => $vendor_id,
                'Balance' => $new_balance,
            ]);

            // Log the wallet funding transaction
            DB::table('tbl_wallet_transaction')->insert([
                'walletID' => $walletID,
                'amount' => $amount_paid,
                'transaction_reference' => $transaction_id,
                'transaction_type' => 'Credit',
                'transaction_description' => 'Wallet funded with ' . $amount_paid,
            ]);
        } else {
            // Update the existing wallet balance
            $new_balance += $wallet->Balance;

            DB::table('tbl_wallet')
                ->where('customerID', $vendor_id)
                ->update(['Balance' => $new_balance]);

            // Log the wallet funding transaction
            DB::table('tbl_wallet_transaction')->insert([
                'walletID' => $wallet->wallet_id,
                'amount' => $amount_paid,
                'transaction_reference' => $transaction_id,
                'transaction_type' => 'Credit',
                'transaction_description' => 'Wallet funded with ' . $amount_paid,
            ]);
        }

        // Check if the wallet update and transaction insertion were successful
        if (isset($walletID) || ($wallet && $wallet->wallet_id)) {
            return response()->json(['status' => 'success', 'message' => 'Payment Successful']);
        } else {
            return response()->json(['status' => 'error', 'message' => 'Payment Failed']);
        }
    }

    public function handleDirectWalletPayment(request $request)
    {
        $transaction_ref ='W'.$request->walletID.date('Y').date('d').date('hs').date('m');

        $updateWalletTransaction = DB::table('tbl_wallet_transaction')->insert([
            'walletID' => $request->walletID,
            'transaction_reference' => $transaction_ref,
            'amount' => $request->amount,
            'transaction_description' => 'Payment of '.number_format($request->amount).' for a policy',
            'transaction_type' => 'Debit',
        ]);

        $amount = $request->amount;
        $transRef = $transaction_ref;
        $orderid = $request->orderID;

        //update order table to show transaction has been confirmed
        $updatequery = DB::table('tbl_order')
            ->where('order_id', $orderid)
            ->update(['order_statusID' => 5]);

        $today = date('Y-m-d H:i:s');
        $eff_date = date_create($today);
        $duration = date_add(
            $eff_date,
            date_interval_create_from_date_string('365 days')
        );
        $end_date = date_format($duration, 'Y-m-d H:i:s');


        $orderData = DB::table('tbl_order')
            // ->join(
            //     'tbl_transaction',
            //     'tbl_transaction.orderID',
            //     '=',
            //     'tbl_order.order_id'
            // )
            ->join(
                'tbl_subpolicy',
                'tbl_subpolicy.upc',
                '=',
                'tbl_order.subPolicyID'
            )
            ->join(
                'tbl_policy',
                'tbl_policy.policy_id',
                '=',
                'tbl_subpolicy.policyID'
            )
            //->join('tbl_order_status', 'tbl_order_status.order_status_id', '=', 'tbl_order.order_statusID')
            ->WHERE('order_id', '=', $orderid)
            //->orderBy('transaction_date', 'desc')
            ->limit(1)
        ->get();
        //dd($orderData);

        $policyno =
            'VKA/' .
            $orderData['0']->sku .
            '/' .
            date('Y') .
            '/' .
            $orderData['0']->upc .
            '/' .
            '10' .
            $orderData['0']->order_id;
            //dd($orderData);

            //naicom upload
            //dd($uploadToNiid);

            $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
            $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
            $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
            $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
            $companyType = 'G';
            $companyId = '74';
            $means_of_id = 'PASSPORT'; //$orderData['0']->form_of_id ?? $orderData['0']->form_of_id ?: 'PASSPORT';
            $means_of_id_number =
                $orderData['0']->id_number ?? $orderData['0']->id_number ?:
                '123456789';
            $insured =
                $orderData['0']->firstName . ' ' . $orderData['0']->lastName;
            $effective_date = date('m/d/Y H:i:s A', strtotime($today));
            $expiration_date = date('m/d/Y H:i:s A ', strtotime($end_date));
            $premium = $orderData['0']->subPolicy_price;
            $product_name = $orderData['0']->policy_name;
            $policy_number = $policyno;
            $sum_insured = $orderData['0']->sum_insured;
            $registration_number = $orderData['0']->car_reg_number;
            $address = $orderData['0']->address;
            $phone =
                trim($orderData['0']->phone) ?? trim($orderData['0']->phone) ?:
                '+234(0)700 1000 500';
            $email =
                trim($orderData['0']->email) ?? trim($orderData['0']->email) ?:
                'info@veritaskapital.com';
            $last_name =
                $orderData['0']->lastName ?? $$orderData->lastName[1] ?: 'n/a';

            switch ($orderData['0']->policyID) {
                case '3':
                    $post_data = [
                        
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Auto',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '127',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CoverageType',
                                        'Value' => 'THIRD_PARTY',
                                    ],
                                    [
                                        'Name' => 'OwnerType',
                                        'Value' => 'PERSON',
                                    ],
                                    [
                                        'Name' => 'OwnerLicense',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'OrgType',
                                        'Value' => 'PRIVATE',
                                    ],
                                    [
                                        'Name' => 'OrgName',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'OrgID',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Kogi',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => '1000000',
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VehicleID',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'PlateNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegNo',
                                        'Value' => $registration_number,
                                    ],
                                    [
                                        'Name' => 'RegDate',
                                        'Value' => 'June 07, 2020', //strtotime('m d, Y')
                                    ],
                                    [
                                        'Name' => 'RegExpDate',
                                        'Value' => 'June 07, 2024',
                                    ],
                                    [
                                        'Name' => 'RegMileage',
                                        'Value' => '100000',
                                    ],
                                    [
                                        'Name' => 'AutoType',
                                        'Value' => 'CAR',
                                    ],
                                    [
                                        'Name' => 'AutoMake',
                                        'Value' =>
                                            $orderData['0']->vehicle_make,
                                    ],
                                    [
                                        'Name' => 'AutoModel',
                                        'Value' =>
                                            $orderData['0']->vehicle_model,
                                    ],
                                    [
                                        'Name' => 'AutoColor',
                                        'Value' => 'Custom',
                                    ],
                                    [
                                        'Name' => 'AutoYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'EngineCap',
                                        'Value' => '2.5',
                                    ],
                                    [
                                        'Name' => 'SeatCap',
                                        'Value' => '5',
                                    ],
                                    [
                                        'Name' => 'AutoNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    break;
                case '4':
                    $product_type_id = '30';
                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Fire',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => $product_type_id,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'CustomerName',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingDoorNo',
                                        'Value' => '3',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingName',
                                        'Value' => 'Personal Building',
                                    ],
                                    [
                                        'Name' => 'CustomerBuildingAddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressCityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressState',
                                        'Value' => 'Kaduna',
                                    ],
                                    [
                                        'Name' =>
                                            'CustomerBuildingAddressPostCode',
                                        'Value' => '900211',
                                    ],
                                    [
                                        'Name' => 'CustomerPhone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'CustomerEmail',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'PropertyBusiness',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstruction',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyConstructionValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'PropertyContent',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'PropertyContentValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'FireCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireProtectionDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'FireHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryAntiTheftDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'BurglaryHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseBuildingType',
                                        'Value' => 'PRIVATE_DEVELLING',
                                    ],
                                    [
                                        'Name' => 'HouseCoverageDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseSecurityDetail',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'HouseHistory',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Fire Insurance
                    break;

                case '1':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => 53,
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of Personal Insurance
                    break;

                case '2':
                    $product_type_id = '53';

                    $post_data = [
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'misc',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '54',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => $product_name,
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'HolderType',
                                        'Value' => 'INDIVIDUAL',
                                    ],
                                    [
                                        'Name' => 'PersonNameLast',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'PersonNameFirst',
                                        'Value' => $last_name,
                                    ],
                                    [
                                        'Name' => 'PersonIDDoc',
                                        'Value' => $means_of_id,
                                    ],
                                    [
                                        'Name' => 'PersonIDNo',
                                        'Value' => $means_of_id_number,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Abuja',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Abia',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '90211',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuranceDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' => $sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
                    //End of House Holder Insurance
                    break;

                case '7':
                    $post_data = [
                        // "SID" => $sid_live,
                        // "Token" => $sid_live,
                        'SID' => $sid_live,
                        'Token' => $token_live,
                        'Type' => 'Marine',
                        'DataGroup' => [
                            [
                                'GroupName' => 'Basic Info',
                                'GroupTag' => 0,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'Insurer',
                                        'Value' =>
                                            'Veritas Kapital Assurance PLC',
                                    ],
                                    [
                                        'Name' => 'TypeID',
                                        'Value' => '41',
                                    ],
                                    [
                                        'Name' => 'CoverageStartDate',
                                        'Value' => $effective_date,
                                    ],
                                    [
                                        'Name' => 'CoverageEndDate',
                                        'Value' => $expiration_date,
                                    ],
                                    [
                                        'Name' => 'PolicyInternalID',
                                        'Value' => $policy_number,
                                    ],
                                    [
                                        'Name' => 'PolicyDescription',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'RecorderType',
                                        'Value' => 'Company',
                                    ],
                                    [
                                        'Name' => 'DetailType',
                                        'Value' => 'Marine',
                                    ],
                                    [
                                        'Name' => 'InsuredType',
                                        'Value' => 'Marine',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Detail Info',
                                'GroupTag' => 1,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'OwnerName',
                                        'Value' => $insured,
                                    ],
                                    [
                                        'Name' => 'AddressLine',
                                        'Value' => $address,
                                    ],
                                    [
                                        'Name' => 'CityLGA',
                                        'Value' => 'Garki',
                                    ],
                                    [
                                        'Name' => 'State',
                                        'Value' => 'Kogi',
                                    ],
                                    [
                                        'Name' => 'PostCode',
                                        'Value' => '11755',
                                    ],
                                    [
                                        'Name' => 'Phone',
                                        'Value' => $phone,
                                    ],
                                    [
                                        'Name' => 'CoverageType',
                                        'Value' => 'General',
                                    ],
                                    [
                                        'Name' => 'Email',
                                        'Value' => $email,
                                    ],
                                    [
                                        'Name' => 'InsuredValue',
                                        'Value' =>
                                            $orderData['0']
                                                ->percent_sum_insured,
                                    ],
                                    [
                                        'Name' => 'Premium',
                                        'Value' => $premium,
                                    ],
                                    [
                                        'Name' => 'CommissionFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'ExtraFee',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'PremiumNote',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Terms',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Preamble',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Endorsements',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exclusions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Exceptions',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'Conditions',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                            [
                                'GroupName' => 'Insured Info',
                                'GroupTag' => 2,
                                'GroupCount' => 0,
                                'AttArray' => [
                                    [
                                        'Name' => 'InsuredNo',
                                        'Value' => '1',
                                    ],
                                    [
                                        'Name' => 'VessleName',
                                        'Value' =>
                                            $orderData['0']->vessel_reg_number,
                                    ],
                                    [
                                        'Name' => 'VessleRegNo',
                                        'Value' =>
                                            $orderData['0']->vessel_reg_number,
                                    ],
                                    [
                                        'Name' => 'VessleType',
                                        'Value' => $orderData['0']->vessel_type,
                                    ],
                                    [
                                        'Name' => 'VessleInsuredValue',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'VessleBuildYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'VessleMakeModel',
                                        'Value' =>
                                            $orderData['0']->vessel_make_model,
                                    ],
                                    [
                                        'Name' => 'VesslePurchaseYear',
                                        'Value' => '2020',
                                    ],
                                    [
                                        'Name' => 'VesslePurchaseValue',
                                        'Value' => '0',
                                    ],
                                    [
                                        'Name' => 'VessleUsage',
                                        'Value' => 'n/a',
                                    ],
                                    [
                                        'Name' => 'VessleCapacityPassenger',
                                        'Value' => '12',
                                    ],
                                    [
                                        'Name' => 'VessleNote',
                                        'Value' => 'n/a',
                                    ],
                                ],
                            ],
                        ],
                    ];
            }

            $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
            $url_test =
                'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => $url_live,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($post_data),
                CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            ]);

            $response = curl_exec($curl);

            curl_close($curl);
            // echo $response;
            // return $response;

            $naicom_upload = json_decode($response, true);
            //dd($curl);
            //dd($naicom_upload);
            //SAVE NAICOM RETURN RECORD TO DB
            $uploadToNaicom = DB::table('naicom_upload')->insert([
                'policy_number' => $policyno,
                'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                'naicom_policy_id' => $naicom_upload['PolicyID'],
                'insured_name' => $insured,
                'contact_address' => $address,
                'phone' => $phone,
                'email' => $email,
                'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
                'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                'sum_assured' => $sum_insured,
                'premium' => $premium,
                'product_name' => $product_name,
                'date_attempted' => date('Y-m-d H:i:s'),
                'message' => !empty($naicom_upload['ErrMsgs']['0'])
                    ? $naicom_upload['ErrMsgs']['0']
                    : 'Successful',
                'is_successful' => $naicom_upload['IsSucceed'],
                'create_by' => $email,
            ]);
            //$naicom_data =  new stdClass();
            //dd($uploadToNaicom);
            
            if ($orderData['0']->policyID == 3) {
                $uploadToNiid = (new NiipController)->niipUpload($orderData['0']->order_id, $policyno, $eff_date, $naicom_upload['PolicyUniqueID']);
                //upload motor policy to NIID
                // $uploadToNiid = DB::table(
                //     '3rd_niid_web_service_register'
                // )->insert([
                //     'policy_no' => $policyno,
                //     'insured_name' =>
                //         $orderData['0']->firstName .
                //         ' ' .
                //         $orderData['0']->lastName,
                //     'contact_address' => $orderData['0']->address,
                //     'gsm' => $orderData['0']->phone,
                //     'email' => $orderData['0']->email,
                //     'eff_from_date' => $today,
                //     'eff_to_date' => $end_date,
                //     'type_of_cover' => 'T',
                //     'vehicle_category' => 'TBA',
                //     'engine_no' => $orderData['0']->car_reg_number,
                //     'chasis_no' => $orderData['0']->car_reg_number,
                //     'vehicle_color' => $orderData['0']->colour,
                //     'year_of_make' => 'year_made',
                //     'vehicle_make' => $orderData['0']->vehicle_make,
                //     'registration_no' => $orderData['0']->car_reg_number,
                //     'vehicle_type' => $orderData['0']->subPolicy_name,
                //     'engine_capacity' => 'TBA',
                //     'vehicle_model' => $orderData['0']->vehicle_model,
                //     'sum_assured' => $orderData['0']->sum_insured,
                //     'premium' => $orderData['0']->subPolicy_price,
                //     'cover_note_no' => 'TBA',
                //     'certificate_no' => 'TBA',
                //     'geographical_zone' => $orderData['0']->state,
                //     'message' => '',
                //     'is_successful' => 0,
                //     'date_attempted' => now(),
                // ]);
            }

            // add NAICOM uid and policy_no to transactions table
            if ($uploadToNaicom) {

                $updateWallet = DB::table('tbl_wallet')->where('wallet_id', $request->walletID)->update([
                    'Balance' => $request->walletBalance - $request->amount,
                ]);

                $updatetransactions = DB::table('tbl_transaction')->insertGetId([
                    'orderID' => $request->orderID,
                    'transaction_ref' => $transaction_ref,
                    'payment_method' => 'Wallet',
                    'payment_statusID' => 5,
                    'amount' => $request->amount,
                    'transaction_date' => now(),
                    'policy_number' => $policyno,
                    'naicom_uid' => $naicom_upload['PolicyUniqueID'],
                    'eff_from_date' => date('Y-m-d', strtotime($today)),
                    'eff_to_date' => date('Y-m-d', strtotime($end_date)),
                ]);

                $uploadToReports = DB::table('retail_report')->insert([
                    'firstname' => $orderData['0']->firstName,
                    'lastname' => $last_name,
                    'email' => $email,
                    'address' => $address,
                    'telephone' => $phone,
                    'order_id' => $orderid,
                    'order_status' => $orderData['0']->order_statusID,
                    'product_name' => $product_name,
                    'product_model' => $product_name,
                    'price' => $premium,
                    'policy_number' => $policyno,
                    'sku' => $orderData['0']->sku,
                    'upc' => $orderData['0']->upc,
                    'form_of_id' => $orderData['0']->form_of_id,
                    'id_number' => $orderData['0']->id_number,
                    'vehicle_make' => $orderData['0']->vehicle_make,
                    'vehicle_model' => $orderData['0']->vehicle_model,
                    'reg_no' => $sum_insured,
                    'chassis_no' => $orderData['0']->chasis_number,
                    'color' => $orderData['0']->colour,
                    'date_added' => date('Y-m-d H:i:s'),
                    'end_date' => $end_date,
                ]);
                # code...
                if ($updatetransactions && $uploadToReports) {
                    //$SendCustomerEmail = (new MailController)->sendCustomerEmail($orderData, $insertIntoDB, $email);
                    //$SendRetailEmail = (new MailController)->sendRetailEmail($orderData, $policyno, $eff_date, $end_date, $transRef, $amount);
                    //$NIIDMarine = (new SoapController)->marineToNiid($orderData, $policyno, $eff_date, $naicom_upload['PolicyUniqueID'], $transRef, $amount);
                    session()->pull('orderID');

                    //session()->put('transID', $orderData['0']->transaction_id);

                    //return view('body.purchaseSuccess', compact('orderData'));
                    return 'success';
                }
            }

    }

}
