<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Paystack;
use PDF;

use function PHPUnit\Framework\isEmpty;

class WhatsappSalesController extends Controller
{
    public function getWhatsappDetails($id)
    {
        $getData = DB::connection('mysql2')
            ->table('retail_policy_detail')
            ->join('retail_transaction', 'retail_transaction.pid', '=', 'retail_policy_detail.id')
            ->join('retail_policy', 'retail_policy.policy_detail_id', '=', 'retail_policy_detail.id')
            ->join('products', 'retail_policy_detail.product_code', '=', 'products.prod_code')
            ->where('retail_policy_detail.id', '=', $id)
            ->orderByDesc('retail_transaction.date_paid')
            ->first();
            //dd($getData);
            $polNum = $getData->policy_number;
             //dd($polNum);
        
        if (!$getData) {
            return view('body.whatsappSales')->with([
                'errorCertMsg' => 'Policy Does Not Exist!',
            ]);
        } elseif ($getData->trans_status == 'paid' && $getData->status == '1') {
            
            if($getData->naicomID == ''){ //check if naicom ID exists
                
                 $naicom = $this->uploadToNaicom($getData, $id);
            }
            
            return view('body.whatsappSales')->with(['successCertMsg' => 'Policy Already Purchased!', 'id' => $id]);
        } elseif ($getData->trans_status === 'unpaid' && $getData->status == '0') {
            //return Paystack::getAuthorizationUrl()->redirectNow();
            //dd('DO Nothing');
            $url = 'https://api.paystack.co/transaction/initialize';

            //"transaction_charge" => $data['user_comm'],

            $fields = [
                'email' => 'vkaitdept@gmail.com',
                'amount' => $getData->premium * 100,
                //'subaccount' => getEnv('PAYSTACK_SUB_ACCOUNT'),
                'callback_url' => url(
                    'payment/whatsappCallback/{reference_id}'
                ),
                'metadata' => ['id' => $id],
            ];

            $fields_string = http_build_query($fields);

            //open connection
            $ch = curl_init();

            //set the url, number of POST vars, POST data
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer sk_live_e4d90ae11137a804dcdeb86cb82c47e5b327c692', // sk_test_ed0517bf606e293e42e1e61bfb5b32455e1950e1', //.getEnv('PAYSTACK_SECRET_KEY'), sk_live_e4d90ae11137a804dcdeb86cb82c47e5b327c692
                'Cache-Control: no-cache',
            ]);

            //So that curl_exec returns the contents of the cURL; rather than echoing it
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            //execute post
            $curl_result = curl_exec($ch);
            $result = json_decode($curl_result);
            //dd($curl_result);

            $auth_url = $result->data->authorization_url;
            return redirect($auth_url);
        }
    }

    public function verifyWhatsappPayment(request $request)
    {
        $reference = $request->reference;

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL =>
                'https://api.paystack.co/transaction/verify/' . $reference,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => [
                'Authorization: Bearer sk_live_e4d90ae11137a804dcdeb86cb82c47e5b327c692', //sk_test_ed0517bf606e293e42e1e61bfb5b32455e1950e1', //. getEnv('PAYSTACK_SECRET_KEY'),
                'Cache-Control: no-cache',
            ],
        ]);

        $response = curl_exec($curl);

        $err = curl_error($curl);
        curl_close($curl);
        $json_response = json_decode($response);
        
        if ($json_response->status && $json_response->data->status == 'success') {
            $response = $this->updateCustomerPayments(
                $json_response->data->metadata->id,
                $json_response->data->reference,
                $json_response->data->amount,
                $json_response->data->transaction_date
            );
            
            if($response['status'] == 'success'){
                return view('body.whatsappSales', ['successCertMsg'=>"Payment Successful!",'id'=>$response['id']]);
            }else{
                return view('body.whatsappSales')->with(['errorCertMsg'=>$response['errorCertMsg']]);
            }
            
            
        }
    }

    public function updateCustomerPayments($id, $reference, $premium, $trans_date)
    {
            $insert = DB::connection('mysql2')
                ->table('retail_transaction')
                ->insert([
                    'transaction_code' => $reference,
                    'user_id'=>'100'.$id,
                    'trans_status' => 'paid',
                    'amount' => $premium/100,
                    'transaction_date' => date('Y/m/d', strtotime($trans_date)), //$trans_date,
                    'status' => 1,
                    'pid' => $id,
                    'phid'=>0,
                    'payment_method' => 'PAYSTACK',
                    'date_paid' => date('Y/m/d', strtotime($trans_date)), //$trans_date,
            ]);
        if ($insert) {
            $data = DB::connection('mysql2')
                ->table('retail_policy_detail')
                ->join(
                    'retail_policy',
                    'retail_policy.policy_detail_id',
                    '=',
                    'retail_policy_detail.id'
                )
                ->join(
                    'products',
                    'retail_policy_detail.product_code',
                    '=',
                    'products.prod_code'
                )
                ->where('retail_policy_detail.id', '=', $id)
                ->first();
                //dd($data);

            if (isset($data->category_id) && $data->category_id===11) {
               $niid =  $this->uploadToNiid($data);
              // dd($niid);
            }
            
            //uncomment this only when NAICOM platform is down
            //return ["status" => "error", "errorCertMsg" => "Policy Purchased Successfully and uploaded to NIID \n\n However, note that you will receive your certificate via the registered email as soon as NAICOM Portal is back online "];
             
            $naicom = $this->uploadToNaicom($data, $id);
            //dd($naicom);

            if ($naicom == '0') {
                $SendCustomerEmail = (new MailController)->sendWhatsappCustomerEmail($data, $id);
                return ["status" => "success", "id" => $id];
                //return back()->with(['successCertMsg'=>"Payment Successful!",'id'=>$id]);
            }else {
                return ["status" => "error", "errorCertMsg" => "Error Encountered. Try again"];
                //return view('body.whatsappSales')->with(['errorCertMsg'=>"Error Occured!"]);
            }

        }
    }

    public function uploadToNaicom($policy_detail, $id)
    {
        $product_category = $policy_detail->category_id;
        //dd($product_category);
        $sid_live = 'f409a7ac-1140-4d39-8348-bb72310f60aa';
        $token_live = 'R+b4Xf3W2Eispwn0QBE5TYNIu3IxD2Cq';
        $sid_test = 'd5c6ffef-a99a-405a-9f85-6392f86bffb1';
        $token_test = 'RJFKerqc2Ejv/8bVmqlaQJ+FY5L4a/+x';
        $companyType = 'G';
        $companyId = '74';
        $means_of_id = 'PASSPORT';
        $means_of_id_number = '123456789';
        // $means_of_id = $policy_detail->means_of_id_type ?? $policy_detail->means_of_id_type ?: 'PASSPORT';
        // $means_of_id_number = $policy_detail->means_of_id_number ?? $policy_detail->means_of_id_number ?: '123456789';
        $insured = $policy_detail->insured_name;
        $effective_date = date('m/d/Y H:i:s A', strtotime($policy_detail->eff_from_date));
        $expiration_date = date('m/d/Y H:i:s A ', strtotime($policy_detail->eff_to_date));
        $premium = $policy_detail->premium;
        $product_name = $policy_detail->product_name;
        $policy_number = $policy_detail->policy_number;
        $sum_insured = $policy_detail->sum_insured;
        $address = $policy_detail->address;
        $phone = trim($policy_detail->phone) ?? trim($policy_detail->phone) ?: '+234(0)700 1000 500';
        $email = trim($policy_detail->email) ?? trim($policy_detail->email) ?: 'info@veritaskapital.com';
        $_last_name = explode(' ', $insured);
        $last_name = array_key_exists($_last_name[1], $_last_name) ?? $_last_name[1] ?: 'n/a';

        switch ($product_category) {
            case '7':
                $product_type_id = '30';
                $post_data = [
                    'SID' => $sid_live,
                    'Token' => $token_live,
                    'Type' => 'Fire',
                    'DataGroup' => [
                        [
                            'GroupName' => 'Basic Info',
                            'GroupTag' => 0,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'TypeID',
                                    'Value' => $product_type_id,
                                ],
                                [
                                    'Name' => 'CoverageStartDate',
                                    'Value' => $effective_date,
                                ],
                                [
                                    'Name' => 'CoverageEndDate',
                                    'Value' => $expiration_date,
                                ],
                                [
                                    'Name' => 'PolicyInternalID',
                                    'Value' => $policy_number,
                                ],
                                [
                                    'Name' => 'PolicyDescription',
                                    'Value' => 'n/a',
                                ],
                            ],
                        ],
                        [
                            'GroupName' => 'Detail Info',
                            'GroupTag' => 1,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'CustomerName',
                                    'Value' => $insured,
                                ],
                                [
                                    'Name' => 'CustomerBuildingDoorNo',
                                    'Value' => '3',
                                ],
                                [
                                    'Name' => 'CustomerBuildingName',
                                    'Value' => 'Personal Building',
                                ],
                                [
                                    'Name' => 'CustomerBuildingAddressLine',
                                    'Value' => $address,
                                ],
                                [
                                    'Name' => 'CustomerBuildingAddressCityLGA',
                                    'Value' => 'Abuja',
                                ],
                                [
                                    'Name' => 'CustomerBuildingAddressState',
                                    'Value' => 'Kaduna',
                                ],
                                [
                                    'Name' => 'CustomerBuildingAddressPostCode',
                                    'Value' => '900211',
                                ],
                                [
                                    'Name' => 'CustomerPhone',
                                    'Value' => $phone,
                                ],
                                [
                                    'Name' => 'CustomerEmail',
                                    'Value' => $email,
                                ],
                                [
                                    'Name' => 'PropertyBusiness',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'PropertyConstruction',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'PropertyConstructionValue',
                                    'Value' => $sum_insured,
                                ],
                                [
                                    'Name' => 'PropertyContent',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'PropertyContentValue',
                                    'Value' => $sum_insured,
                                ],
                                [
                                    'Name' => 'FireCoverageDetail',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'FireProtectionDetail',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'FireHistory',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'BurglaryCoverageDetail',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'BurglaryAntiTheftDetail',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'BurglaryHistory',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'HouseBuildingType',
                                    'Value' => 'PRIVATE_DEVELLING',
                                ],
                                [
                                    'Name' => 'HouseCoverageDetail',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'HouseSecurityDetail',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'HouseHistory',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'InsuredValue',
                                    'Value' => $sum_insured,
                                ],
                                [
                                    'Name' => 'Premium',
                                    'Value' => $premium,
                                ],
                                [
                                    'Name' => 'CommissionFee',
                                    'Value' => '0',
                                ],
                                [
                                    'Name' => 'ExtraFee',
                                    'Value' => '0',
                                ],
                                [
                                    'Name' => 'PremiumNote',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Terms',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Preamble',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Endorsements',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Exclusions',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Exceptions',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Conditions',
                                    'Value' => 'n/a',
                                ],
                            ],
                        ],
                    ],
                ];

                //Fire Insurance;
                break;
            case '8':
                $product_type_id = '54';

                $post_data = [
                    'SID' => $sid_live,
                    'Token' => $token_live,
                    'Type' => 'misc',
                    'DataGroup' => [
                        [
                            'GroupName' => 'Basic Info',
                            'GroupTag' => 0,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'TypeID',
                                    'Value' => '54',
                                ],
                                [
                                    'Name' => 'CoverageStartDate',
                                    'Value' => $effective_date,
                                ],
                                [
                                    'Name' => 'CoverageEndDate',
                                    'Value' => $expiration_date,
                                ],
                                [
                                    'Name' => 'PolicyInternalID',
                                    'Value' => $policy_number,
                                ],
                                [
                                    'Name' => 'PolicyDescription',
                                    'Value' => $product_name,
                                ],
                            ],
                        ],
                        [
                            'GroupName' => 'Detail Info',
                            'GroupTag' => 1,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'HolderType',
                                    'Value' => 'INDIVIDUAL',
                                ],
                                [
                                    'Name' => 'PersonNameLast',
                                    'Value' => $insured,
                                ],
                                [
                                    'Name' => 'PersonNameFirst',
                                    'Value' => $last_name,
                                ],
                                [
                                    'Name' => 'PersonIDDoc',
                                    'Value' => $means_of_id,
                                ],
                                [
                                    'Name' => 'PersonIDNo',
                                    'Value' => $means_of_id_number,
                                ],
                                [
                                    'Name' => 'AddressLine',
                                    'Value' => $address,
                                ],
                                [
                                    'Name' => 'CityLGA',
                                    'Value' => 'Abuja',
                                ],
                                [
                                    'Name' => 'State',
                                    'Value' => 'Abia',
                                ],
                                [
                                    'Name' => 'PostCode',
                                    'Value' => '90211',
                                ],
                                [
                                    'Name' => 'Phone',
                                    'Value' => $phone,
                                ],
                                [
                                    'Name' => 'Email',
                                    'Value' => $email,
                                ],
                                [
                                    'Name' => 'InsuranceDescription',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'InsuredValue',
                                    'Value' => $sum_insured,
                                ],
                                [
                                    'Name' => 'Premium',
                                    'Value' => $premium,
                                ],
                                [
                                    'Name' => 'CommissionFee',
                                    'Value' => '0',
                                ],
                                [
                                    'Name' => 'ExtraFee',
                                    'Value' => '0',
                                ],
                                [
                                    'Name' => 'PremiumNote',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Terms',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Preamble',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Endorsements',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Exclusions',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Exceptions',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Conditions',
                                    'Value' => 'n/a',
                                ],
                            ],
                        ],
                    ],
                ];

                //Personal Insurance;
                break;
            case '9':
                $product_type_id = '53';

                $post_data = [
                    'SID' => $sid_live,
                    'Token' => $token_live,
                    'Type' => 'misc',
                    'DataGroup' => [
                        [
                            'GroupName' => 'Basic Info',
                            'GroupTag' => 0,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'TypeID',
                                    'Value' => '54',
                                ],
                                [
                                    'Name' => 'CoverageStartDate',
                                    'Value' => $effective_date,
                                ],
                                [
                                    'Name' => 'CoverageEndDate',
                                    'Value' => $expiration_date,
                                ],
                                [
                                    'Name' => 'PolicyInternalID',
                                    'Value' => $policy_number,
                                ],
                                [
                                    'Name' => 'PolicyDescription',
                                    'Value' => $product_name,
                                ],[
                                    'Name' => 'RecorderType',
                                    'Value' => 'Company',
                                ],
                            ],
                        ],
                        [
                            'GroupName' => 'Detail Info',
                            'GroupTag' => 1,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'HolderType',
                                    'Value' => 'INDIVIDUAL',
                                ],
                                [
                                    'Name' => 'PersonNameLast',
                                    'Value' => $insured,
                                ],
                                [
                                    'Name' => 'PersonNameFirst',
                                    'Value' => $last_name,
                                ],
                                [
                                    'Name' => 'PersonIDDoc',
                                    'Value' => $means_of_id,
                                ],
                                [
                                    'Name' => 'PersonIDNo',
                                    'Value' => $means_of_id_number,
                                ],
                                [
                                    'Name' => 'AddressLine',
                                    'Value' => $address,
                                ],
                                [
                                    'Name' => 'CityLGA',
                                    'Value' => 'Abuja',
                                ],
                                [
                                    'Name' => 'State',
                                    'Value' => 'Abia',
                                ],
                                [
                                    'Name' => 'PostCode',
                                    'Value' => '90211',
                                ],
                                [
                                    'Name' => 'Phone',
                                    'Value' => $phone,
                                ],
                                [
                                    'Name' => 'Email',
                                    'Value' => $email,
                                ],
                                [
                                    'Name' => 'InsuranceDescription',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'InsuredValue',
                                    'Value' => $sum_insured,
                                ],
                                [
                                    'Name' => 'Premium',
                                    'Value' => $premium,
                                ],
                                [
                                    'Name' => 'CommissionFee',
                                    'Value' => '0',
                                ],
                                [
                                    'Name' => 'ExtraFee',
                                    'Value' => '0',
                                ],
                                [
                                    'Name' => 'PremiumNote',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Terms',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Preamble',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Endorsements',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Exclusions',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Exceptions',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Conditions',
                                    'Value' => 'n/a',
                                ],
                            ],
                        ],
                    ],
                ];
                //House Holder Insurance
                break;

            default:
                $registration_number = $policy_detail->reg_no;
                $vehicle_make = $policy_detail->vehicle_make;
                $vehicle_model = $policy_detail->vehicle_model;
                $post_data = [
                    // "SID" => $sid_live,
                    // "Token" => $sid_live,
                    'SID' => $sid_live,
                    'Token' => $token_live,
                    'Type' => 'Auto',
                    'DataGroup' => [
                        [
                            'GroupName' => 'Basic Info',
                            'GroupTag' => 0,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'TypeID',
                                    'Value' => '127',
                                ],
                                [
                                    'Name' => 'CoverageStartDate',
                                    'Value' => $effective_date,
                                ],
                                [
                                    'Name' => 'CoverageEndDate',
                                    'Value' => $expiration_date,
                                ],
                                [
                                    'Name' => 'PolicyInternalID',
                                    'Value' => $policy_number,
                                ],
                                [
                                    'Name' => 'PolicyDescription',
                                    'Value' => 'n/a',
                                ],[
                                    'Name' => 'RecorderType',
                                    'Value' => 'Company',
                                ],
                            ],
                        ],
                        [
                            'GroupName' => 'Detail Info',
                            'GroupTag' => 1,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'CoverageType',
                                    'Value' => 'THIRD_PARTY',
                                ],
                                [
                                    'Name' => 'OwnerType',
                                    'Value' => 'PERSON',
                                ],
                                [
                                    'Name' => 'OwnerLicense',
                                    'Value' => $registration_number,
                                ],
                                [
                                    'Name' => 'PersonNameLast',
                                    'Value' => $last_name,
                                ],
                                [
                                    'Name' => 'PersonNameFirst',
                                    'Value' => $insured,
                                ],
                                [
                                    'Name' => 'OrgType',
                                    'Value' => 'PRIVATE',
                                ],
                                [
                                    'Name' => 'OrgName',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'OrgID',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'AddressLine',
                                    'Value' => $address,
                                ],
                                [
                                    'Name' => 'CityLGA',
                                    'Value' => 'Garki',
                                ],
                                [
                                    'Name' => 'State',
                                    'Value' => 'Kogi',
                                ],
                                [
                                    'Name' => 'PostCode',
                                    'Value' => '11755',
                                ],
                                [
                                    'Name' => 'Phone',
                                    'Value' => $phone,
                                ],
                                [
                                    'Name' => 'Email',
                                    'Value' => $email,
                                ],
                                [
                                    'Name' => 'InsuredValue',
                                    'Value' => '1000000',
                                ],
                                [
                                    'Name' => 'Premium',
                                    'Value' => $premium,
                                ],
                                [
                                    'Name' => 'CommissionFee',
                                    'Value' => '0',
                                ],
                                [
                                    'Name' => 'ExtraFee',
                                    'Value' => '0',
                                ],
                                [
                                    'Name' => 'PremiumNote',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Terms',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Preamble',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Endorsements',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Exclusions',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Exceptions',
                                    'Value' => 'n/a',
                                ],
                                [
                                    'Name' => 'Conditions',
                                    'Value' => 'n/a',
                                ],
                            ],
                        ],
                        [
                            'GroupName' => 'Insured Info',
                            'GroupTag' => 2,
                            'GroupCount' => 0,
                            'AttArray' => [
                                [
                                    'Name' => 'InsuredNo',
                                    'Value' => '1',
                                ],
                                [
                                    'Name' => 'VehicleID',
                                    'Value' => $registration_number,
                                ],
                                [
                                    'Name' => 'PlateNo',
                                    'Value' => $registration_number,
                                ],
                                [
                                    'Name' => 'RegNo',
                                    'Value' => $registration_number,
                                ],
                                [
                                    'Name' => 'RegDate',
                                    'Value' => 'June 07, 2020',
                                ],
                                [
                                    'Name' => 'RegExpDate',
                                    'Value' => 'June 07, 2023',
                                ],
                                [
                                    'Name' => 'RegMileage',
                                    'Value' => '100000',
                                ],
                                [
                                    'Name' => 'AutoType',
                                    'Value' => 'CAR',
                                ],
                                [
                                    'Name' => 'AutoMake',
                                    'Value' => $vehicle_make,
                                ],
                                [
                                    'Name' => 'AutoModel',
                                    'Value' => $vehicle_model,
                                ],
                                [
                                    'Name' => 'AutoColor',
                                    'Value' => 'Custom',
                                ],
                                [
                                    'Name' => 'AutoYear',
                                    'Value' => '2020',
                                ],
                                [
                                    'Name' => 'EngineCap',
                                    'Value' => '2.5',
                                ],
                                [
                                    'Name' => 'SeatCap',
                                    'Value' => '5',
                                ],
                                [
                                    'Name' => 'AutoNote',
                                    'Value' => 'n/a',
                                ],
                            ],
                        ],
                    ],
                ];
        }

        $url_live = 'https://portal.naicom.gov.ng/api/v1/cp/policy/new';
        $url_test = 'https://testportal.naicom.gov.ng:8443/api/v1/cp/policy/new';

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $url_live,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_data),
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        // echo $response;
        // return $response;

        $naicom_upload = json_decode($response, true);
        //dd($naicom_upload);

        $updatequery = DB::connection('mysql2')->table('retail_policy')
        ->where('policy_detail_id', $id)
        //->update(['naicomID' => 'NAICOMID123456789']);
        ->update(['naicomID' => $naicom_upload['PolicyUniqueID']]);

        $uploadToNaicomTbl = DB::connection('mysql2')->table('naicom_upload')->insert([
            'policy_number' => $policy_number,
            'naicom_uid' => $naicom_upload['PolicyUniqueID'],
            'naicom_policy_id' => $naicom_upload['PolicyID'],
            'insured_name' => $insured,
            'contact_address' => $address,
            'phone' => $phone,
            'email' => $email,
            'eff_from_date' => date('Y-m-d', strtotime($effective_date)),
            'eff_to_date' => date('Y-m-d', strtotime($expiration_date)),
            'sum_assured' => $sum_insured,
            'premium' => $premium,
            'product_name' => $product_name,
            'date_attempted' => date('Y-m-d H:i:s'),
            'message' => !empty($naicom_upload['ErrMsgs']['0'])
                ? $naicom_upload['ErrMsgs']['0']
                : 'Successful',
            'is_successful' => $naicom_upload['IsSucceed'],
            'create_by' => NULL,
        ]);

        return 0;
    }

    public function uploadToNiid($data)
    {
        //dd($data);
        $uploadToNiid = DB::table('3rd_niid_web_service_register')
        ->insert([
            'policy_no' => $data->policy_number,
            'insured_name' => $data->insured_name,
            'contact_address' => $data->address,
            'gsm' => $data->phone,
            'email' => $data->email,
            'eff_from_date' => $data->eff_from_date,
            'eff_to_date' => $data->eff_to_date,
            'type_of_cover' => 'T',
            'vehicle_category' => 'TBA',
            'engine_no' => $data->reg_no,
            'chasis_no' => $data->reg_no,
            'vehicle_color' => 'custom',
            'year_of_make' => '2005',
            'vehicle_make' => $data->vehicle_make,
            'registration_no' => $data->reg_no,
            'vehicle_type' => 'TBA',
            'engine_capacity' => 'TBA',
            'vehicle_model' => $data->vehicle_model,
            'sum_assured' => $data->sum_insured,
            'premium' => $data->premium,
            'cover_note_no' => 'TBA',
            'certificate_no' => 'TBA',
            'geographical_zone' => $data->state,
            'message' => '',
            'is_successful' => 0,
            'date_attempted' => now(),
        ]);
    }
    
    public function generateCertificate($id)
    {
        //dd($id);
        $transData = DB::connection('mysql2')
                ->table('retail_policy_detail')
                ->join(
                    'retail_policy',
                    'retail_policy.policy_detail_id',
                    '=',
                    'retail_policy_detail.id'
                )
                ->join(
                    'products',
                    'retail_policy_detail.product_code',
                    '=',
                    'products.prod_code'
                )
                ->join(
                    'product_category',
                    'products.category_id',
                    '=',
                    'product_category.id'
                )
                ->where('retail_policy_detail.id', '=', $id)
                ->first();

        //dd($transData);
        if ($transData->category_id===11) {
            $pdf = PDF::loadView('body.whatsappCert.Mcertificate', compact('transData'));
            return $pdf->download('certificate.pdf');
            //return view ('body.Mcertificate', compact('transData'));
        } else {
            // $pdf = PDF::loadView('body.certificate', compact('transData'));
            // return $pdf->download('certificate.pdf');
            $pdf = PDF::loadView('body.whatsappCert.certificate', compact('transData'));
            return $pdf->download('certificate.pdf');
        }
    }
}
