<title>Veritas Kapital Assurance PLC - Transactions</title>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li><a href="index"><img src="<?php echo e(asset('assets/img/icons/icon-home.png')); ?>">Home</a></li>
                        <li><a href="<?php echo e(url('customerdash')); ?>">My Dashboard</a> </li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->
        <div id="account-account" class="container dashboard">
            <div class="row">
                <div id="content" class="col-md-9 col-sm-8" style="margin-top:50px;">
                    <div class="dashboard--main">
                        <div class="dashboard--top">
                            <div class="row" >
                                <div class="col-12">
                                    <h2>Transactions History</h2><br /><br/>
                                    <form method="post" name="frmFilter" action="<?php echo e(route('transaction-filter')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="row mb-5">
                                            <div class="col-4">
                                                <label>Date From</label>
                                                <input type="date" name="dateFrom" class="form-control" />
                                            </div>
                                            <div class="col-4">
                                                <label>Date To</label>
                                                <input type="date" name="dateTo" class="form-control" />
                                            </div>
                                            <div class="col-4">
                                                <label>&nbsp;&nbsp;&nbsp;</label>
                                                <input type="submit" name="btnFilter" value="Filter" class="form-control btn btn-lg btn-success" />
                                            </div>
                                        </div>
                                    </form>
                                    <div class="table-responsive" style="overflow-x: auto">
                                        <table class="table table-bordered table-striped table-hover" id="example">
                                        <thead>
                                            <th>Transaction Date</th>
                                            <th>Transaction Ref</th>
                                            <th>Policy Purchased</th>
                                            <th>Customer</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $TransactionData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($data1->order_id == 0): ?>
                                                    <tr>
                                                        <td> No Transactions Has Been Made</td>
                                                    </tr>
                                                <?php else: ?>
                                                    <tr>
                                                        <td><?php echo e(date('Y-m-d', strtotime($data1->transaction_date))); ?></td>
                                                        <td>#<?php echo e($data1->transaction_ref); ?></td>
                                                        <td><?php echo e($data1->policy_name); ?> (<?php echo e($data1->subPolicy_name); ?>)</td>
                                                        <td><?php echo e($data1->firstName); ?> (<?php echo e($data1->lastName); ?>)</td>
                                                        <td><?php echo e(number_format($data1->amount)); ?></td>
                                                        <td><?php echo e($data1->order_status_name); ?></td>
                                                        <td>
                                                            <?php if($data1->policy_id == '6'): ?>
                                                                <a href="<?php echo e($data1->mapfre_certificate_url); ?>" target="blank"><i
                                                                    class="fa fa-print"
                                                                    title="Print Policy Certificate"></i></a> 
                                                            <?php else: ?>
                                                                <a href="certificate/<?php echo e($data1->transaction_id); ?>" target="blank"><i
                                                                    class="fa fa-print"
                                                                    title="Print Policy Certificate"></i></a> 
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <aside class="col-md-3 col-sm-4 col-xs-12 content-aside right_column sidebar-offcanvas">

                    <?php echo $__env->make('layouts.adminnav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                </aside>

            </div>


    </main><!-- End #main -->

    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <Script>
        $(document).ready(function () {
            var table = $('#example').DataTable( {
                    lengthChange: false,
                    buttons: [ 'copy', 'excel', 'pdf', 'colvis' ],
                    order: [[0, 'desc']]
                });

                table.buttons().container()
                    .appendTo( '#example_wrapper .col-md-6:eq(0)' );
                });
    </Script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/retail.veritaskapital.com/resources/views/body/customer/transactions.blade.php ENDPATH**/ ?>