<title>Veritas Kapital Assurance PLC - Account/Login</title>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <main id="main">
        <!-- ======= Breadcrumbs Section ======= -->
        <section class="breadcrumbs">
            <div class="container">
                <div class="d-flex justify-content-between align-items-center">
                    <ol>
                        <li>Account</li>
                        <li>Registration</li>
                    </ol>
                </div>
            </div>
        </section><!-- End Breadcrumbs Section -->

        <!-- ======= Pricing Section ======= -->
        <section id="pricing" class="pricing inner-page">
            <div id="account-register" class="container">
                <div class="row">
                    <div id="content" class="col-sm-9">
                        <h1>Register Account</h1>
                        <p>If you already have an account with us, please login at the <a href="<?php echo e(url('login')); ?>">login
                                page</a>.</p>
                        <?php if(Session::has('RegistrationError')): ?>
                            <div class="alert alert-danger" role="alert">
                                <i class="fa fa-window-close"></i>   <?php echo e(Session::get('RegistrationError')); ?>

                            </div>
                        <?php endif; ?>
                        <form action="<?php echo e(url('/submitRegister')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <fieldset id="account">
                                <legend>Your Personal Details</legend>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-firstname">First Name</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="firstname" value="<?php echo e(old('firstname')); ?>"
                                            placeholder="First Name" id="input-firstname" class="form-control" />
                                    </div>
                                </div>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-lastname">Last Name</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="lastname" value="<?php echo e(old('lastname')); ?>" required
                                            placeholder="Last Name" id="input-lastname" class="form-control" />
                                    </div>
                                </div>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-email">E-Mail Address</label>
                                    <div class="col-sm-10">
                                        <input type="email" name="email" value="<?php echo e(old('email')); ?>"
                                            placeholder="E-Mail Address" id="input-email" required class="form-control" />
                                        <span class="text-danger">
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <?php echo e($message); ?>

                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-telephone">Telephone</label>
                                    <div class="col-sm-10">
                                        <input type="tel" name="phone" value="<?php echo e(old('phone')); ?>" placeholder="Telephone"
                                            id="input-telephone" class="form-control" />
                                    </div>
                                </div>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-vka">VKA Number</label>
                                    <div class="col-sm-10">
                                        <input type="tel" name="vka_id" value="<?php echo e(old('vka_id')); ?>"
                                            placeholder="Enter full VKA ID (For VKA staff only)" id="input-vka_id" class="form-control" />
                                    </div>
                                </div>
                            </fieldset>
                            <fieldset>
                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-password">Password</label>
                                    <div class="col-sm-10">
                                        <input type="password" name="password" value="" required placeholder="Password"
                                            id="input-password" class="form-control" />
                                        <span class="text-danger">
                                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <?php echo e($message); ?>

                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </span>
                                    </div>
                                </div>
                            </fieldset>
                            <fieldset>
                                <div class="form-group">
                                    <label class="col-sm-4 control-label">Subscribe to our newsletter?</label>
                                    <div class="col-sm-10"> <label class="radio-inline">
                                            <input type="radio" name="newsletter" value="1" />
                                            Yes</label>
                                        <label class="radio-inline">
                                            <input type="radio" name="newsletter" value="0" checked="checked" />
                                            No</label>
                                    </div>
                                </div>
                            </fieldset>

                            <div class="buttons">
                                <div class="pull-right">I have read and agree to the <a
                                        href="https://retail.veritaskapital.com/index.php?route=information/information/agree&amp;information_id=3"
                                        required><b>Privacy Policy</b></a>
                                    <input type="checkbox" name="agree" value="1" required />
                                    &nbsp;
                                    <input type="submit" value="Register" class="btn btn-primary" />
                                </div>
                            </div>
                        </form>
        </section><!-- End Pricing Section -->
    </main><!-- End #main -->

    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/veritaskapital/retaildemo.veritaskapital.com/resources/views/body/register.blade.php ENDPATH**/ ?>